/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.server.ejbd;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.openejb.ApplicationException;
import org.openejb.DeploymentInfo;
import org.openejb.InvalidateReferenceException;
import org.openejb.OpenEJB;
import org.openejb.ProxyInfo;
import org.openejb.RpcContainer;
import org.openejb.SystemException;
import org.openejb.client.EJBRequest;
import org.openejb.client.EJBResponse;
import org.openejb.client.RequestMethods;
import org.openejb.client.ResponseCodes;
import org.openejb.server.ejbd.CallContext;
import org.openejb.server.ejbd.EjbDaemon;
import org.openejb.spi.SecurityService;

class EjbRequestHandler
implements ResponseCodes,
RequestMethods {
    private final EjbDaemon daemon;

    EjbRequestHandler(EjbDaemon daemon) {
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processRequest(ObjectInputStream in, ObjectOutputStream out) {
        block36: {
            EJBRequest req = new EJBRequest();
            EJBResponse res = new EJBResponse();
            try {
                req.readExternal(in);
            }
            catch (Throwable t) {
                this.replyWithFatalError(out, t, "Error caught during request processing");
                return;
            }
            CallContext call = null;
            DeploymentInfo di = null;
            Object c = null;
            try {
                di = this.daemon.getDeployment(req);
            }
            catch (RemoteException e) {
                this.replyWithFatalError(out, e, "No such deployment");
                return;
            }
            catch (Throwable t) {
                this.replyWithFatalError(out, t, "Unkown error occured while retrieving deployment");
                return;
            }
            try {
                call = CallContext.getCallContext();
                call.setEJBRequest(req);
                call.setDeploymentInfo(di);
            }
            catch (Throwable t) {
                this.replyWithFatalError(out, t, "Unable to set the thread context for this request");
                return;
            }
            switch (req.getRequestMethod()) {
                case 23: {
                    this.doEjbObject_BUSINESS_METHOD(req, res);
                    break;
                }
                case 10: {
                    this.doEjbHome_CREATE(req, res);
                    break;
                }
                case 9: {
                    this.doEjbHome_FIND(req, res);
                    break;
                }
                case 14: {
                    this.doEjbObject_GET_EJB_HOME(req, res);
                    break;
                }
                case 15: {
                    this.doEjbObject_GET_HANDLE(req, res);
                    break;
                }
                case 16: {
                    this.doEjbObject_GET_PRIMARY_KEY(req, res);
                    break;
                }
                case 17: {
                    this.doEjbObject_IS_IDENTICAL(req, res);
                    break;
                }
                case 18: {
                    this.doEjbObject_REMOVE(req, res);
                    break;
                }
                case 1: {
                    this.doEjbHome_GET_EJB_META_DATA(req, res);
                    break;
                }
                case 2: {
                    this.doEjbHome_GET_HOME_HANDLE(req, res);
                    break;
                }
                case 3: {
                    this.doEjbHome_REMOVE_BY_HANDLE(req, res);
                    break;
                }
                case 4: {
                    this.doEjbHome_REMOVE_BY_PKEY(req, res);
                }
            }
            Object var10_16 = null;
            this.daemon.logger.info("EJB RESPONSE: " + res);
            try {
                res.writeExternal(out);
            }
            catch (IOException ie) {
                this.daemon.logger.fatal("Couldn't write EjbResponse to output stream", ie);
            }
            call.reset();
            {
                break block36;
                catch (InvalidateReferenceException e) {
                    res.setResponse(10, e.getRootCause());
                    Object var10_17 = null;
                    this.daemon.logger.info("EJB RESPONSE: " + res);
                    try {
                        res.writeExternal(out);
                    }
                    catch (IOException ie) {
                        this.daemon.logger.fatal("Couldn't write EjbResponse to output stream", ie);
                    }
                    call.reset();
                    break block36;
                }
                catch (ApplicationException e) {
                    res.setResponse(9, e.getRootCause());
                    Object var10_18 = null;
                    this.daemon.logger.info("EJB RESPONSE: " + res);
                    try {
                        res.writeExternal(out);
                    }
                    catch (IOException ie) {
                        this.daemon.logger.fatal("Couldn't write EjbResponse to output stream", ie);
                    }
                    call.reset();
                    break block36;
                }
                catch (SystemException e) {
                    res.setResponse(11, e.getRootCause());
                    this.daemon.logger.fatal(req + ": OpenEJB encountered an unknown system error in container: ", e);
                    Object var10_19 = null;
                    this.daemon.logger.info("EJB RESPONSE: " + res);
                    try {
                        res.writeExternal(out);
                    }
                    catch (IOException ie) {
                        this.daemon.logger.fatal("Couldn't write EjbResponse to output stream", ie);
                    }
                    call.reset();
                    break block36;
                }
                catch (Throwable t) {
                    this.replyWithFatalError(out, t, "Unknown error in container");
                    Object var10_20 = null;
                    this.daemon.logger.info("EJB RESPONSE: " + res);
                    try {
                        res.writeExternal(out);
                    }
                    catch (IOException ie) {
                        this.daemon.logger.fatal("Couldn't write EjbResponse to output stream", ie);
                    }
                    call.reset();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var10_21 = null;
                this.daemon.logger.info("EJB RESPONSE: " + res);
                try {
                    res.writeExternal(out);
                }
                catch (IOException ie) {
                    this.daemon.logger.fatal("Couldn't write EjbResponse to output stream", ie);
                }
                call.reset();
                throw throwable;
            }
        }
    }

    protected void doEjbObject_BUSINESS_METHOD(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getDeploymentInfo().getContainer();
        Object result = c.invoke(req.getDeploymentId(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey(), req.getClientIdentity());
        if (result instanceof ProxyInfo) {
            ProxyInfo info;
            if (EJBObject.class.isAssignableFrom((info = (ProxyInfo)result).getInterface())) {
                result = this.daemon.clientObjectFactory._getEJBObject(call, info);
            } else if (EJBHome.class.isAssignableFrom(info.getInterface())) {
                result = this.daemon.clientObjectFactory._getEJBHome(call, info);
            } else {
                result = new RemoteException("The container returned a ProxyInfo object that is neither a javax.ejb.EJBObject or javax.ejb.EJBHome: " + info.getInterface());
                this.daemon.logger.error(req + "The container returned a ProxyInfo object that is neither a javax.ejb.EJBObject or javax.ejb.EJBHome: " + info.getInterface());
                res.setResponse(10, result);
                return;
            }
        }
        res.setResponse(4, result);
    }

    protected void doEjbHome_CREATE(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getDeploymentInfo().getContainer();
        Object result = c.invoke(req.getDeploymentId(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey(), req.getClientIdentity());
        if (result instanceof ProxyInfo) {
            ProxyInfo info = (ProxyInfo)result;
            res.setResponse(4, info.getPrimaryKey());
        } else {
            result = new RemoteException("The bean is not EJB compliant.  The should be created or and exception should be thrown.");
            this.daemon.logger.error(req + "The bean is not EJB compliant.  The should be created or and exception should be thrown.");
            res.setResponse(10, result);
        }
    }

    protected void doEjbHome_FIND(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getDeploymentInfo().getContainer();
        Object result = c.invoke(req.getDeploymentId(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey(), req.getClientIdentity());
        if (result instanceof Collection) {
            Object[] primaryKeys = ((Collection)result).toArray();
            for (int i = 0; i < primaryKeys.length; ++i) {
                primaryKeys[i] = ((ProxyInfo)primaryKeys[i]).getPrimaryKey();
            }
            res.setResponse(7, primaryKeys);
        } else if (result instanceof Enumeration) {
            Enumeration resultAsEnum = (Enumeration)result;
            ArrayList<Object> listOfPKs = new ArrayList<Object>();
            while (resultAsEnum.hasMoreElements()) {
                listOfPKs.add(((ProxyInfo)resultAsEnum.nextElement()).getPrimaryKey());
            }
            res.setResponse(20, listOfPKs.toArray(new Object[listOfPKs.size()]));
        } else if (result instanceof ProxyInfo) {
            result = ((ProxyInfo)result).getPrimaryKey();
            res.setResponse(6, result);
        } else {
            String message = "The bean is not EJB compliant. The finder method [" + req.getMethodInstance().getName() + "] is declared " + "to return neither Collection nor the Remote Interface, " + "but [" + result.getClass().getName() + "]";
            result = new RemoteException(message);
            this.daemon.logger.error(req + " " + message);
            res.setResponse(10, result);
        }
    }

    protected void doEjbObject_GET_EJB_HOME(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_GET_HANDLE(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_GET_PRIMARY_KEY(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_IS_IDENTICAL(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_REMOVE(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getDeploymentInfo().getContainer();
        Object result = c.invoke(req.getDeploymentId(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey(), req.getClientIdentity());
        res.setResponse(4, null);
    }

    protected void doEjbHome_GET_EJB_META_DATA(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbHome_GET_HOME_HANDLE(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbHome_REMOVE_BY_HANDLE(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getDeploymentInfo().getContainer();
        Object result = c.invoke(req.getDeploymentId(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey(), req.getClientIdentity());
        res.setResponse(4, null);
    }

    protected void doEjbHome_REMOVE_BY_PKEY(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getDeploymentInfo().getContainer();
        Object result = c.invoke(req.getDeploymentId(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey(), req.getClientIdentity());
        res.setResponse(4, null);
    }

    protected void checkMethodAuthorization(EJBRequest req, EJBResponse res) throws Exception {
        SecurityService sec = OpenEJB.getSecurityService();
        CallContext caller = CallContext.getCallContext();
        DeploymentInfo di = caller.getDeploymentInfo();
        String[] authRoles = di.getAuthorizedRoles(req.getMethodInstance());
        if (sec.isCallerAuthorized(req.getClientIdentity(), authRoles)) {
            res.setResponse(4, null);
        } else {
            this.daemon.logger.info(req + "Unauthorized Access by Principal Denied");
            res.setResponse(9, new RemoteException("Unauthorized Access by Principal Denied"));
        }
    }

    private void replyWithFatalError(ObjectOutputStream out, Throwable error, String message) {
        this.daemon.logger.fatal(message, error);
        RemoteException re = new RemoteException("The server has encountered a fatal error: " + message + " " + error);
        EJBResponse res = new EJBResponse();
        res.setResponse(11, re);
        try {
            res.writeExternal(out);
        }
        catch (IOException ie) {
            this.daemon.logger.error("Failed to write to EJBResponse", ie);
        }
    }
}

