/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.server.ejbd;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.openejb.DeploymentInfo;
import org.openejb.OpenEJB;
import org.openejb.client.EJBMetaDataImpl;
import org.openejb.client.JNDIRequest;
import org.openejb.client.JNDIResponse;
import org.openejb.client.RequestMethods;
import org.openejb.client.ResponseCodes;
import org.openejb.server.ejbd.EjbDaemon;

class JndiRequestHandler
implements ResponseCodes,
RequestMethods {
    private final EjbDaemon daemon;
    Context clientJndi = (Context)OpenEJB.getJNDIContext().lookup("openejb/ejb");

    JndiRequestHandler(EjbDaemon daemon) throws Exception {
        this.daemon = daemon;
    }

    public void processRequest(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        JNDIResponse res;
        block7: {
            DeploymentInfo deployment;
            JNDIRequest req = new JNDIRequest();
            res = new JNDIResponse();
            req.readExternal(in);
            String name = req.getRequestString();
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if ((deployment = this.daemon.deploymentIndex.getDeployment(name)) == null) {
                try {
                    Object obj = this.clientJndi.lookup(name);
                    if (obj instanceof Context) {
                        res.setResponseCode(14);
                        break block7;
                    }
                    res.setResponseCode(16);
                }
                catch (NameNotFoundException e) {
                    res.setResponseCode(16);
                }
                catch (NamingException e) {
                    res.setResponseCode(17);
                    res.setResult(e);
                }
            } else {
                res.setResponseCode(13);
                EJBMetaDataImpl metaData = new EJBMetaDataImpl(deployment.getHomeInterface(), deployment.getRemoteInterface(), deployment.getPrimaryKeyClass(), deployment.getComponentType(), deployment.getDeploymentID().toString(), this.daemon.deploymentIndex.getDeploymentIndex(name));
                res.setResult(metaData);
            }
        }
        res.writeExternal(out);
    }
}

