/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.server.telnet;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.openejb.server.telnet.Command;
import org.openejb.util.Logger;

public class TextConsole {
    Logger logger = Logger.getInstance("OpenEJB.admin", "org.openejb.server.util.resources");
    Properties props;
    boolean stop = false;
    DataInputStream in = null;
    PrintStream out = null;
    public static final char ESC = '\u001b';
    public static final String TTY_Reset = "\u001b[0m";
    public static final String TTY_Bright = "\u001b[1m";
    public static final String TTY_Dim = "\u001b[2m";
    public static final String TTY_Underscore = "\u001b[4m";
    public static final String TTY_Blink = "\u001b[5m";
    public static final String TTY_Reverse = "\u001b[7m";
    public static final String TTY_Hidden = "\u001b[8m";
    public static final String TTY_FG_Black = "\u001b[30m";
    public static final String TTY_FG_Red = "\u001b[31m";
    public static final String TTY_FG_Green = "\u001b[32m";
    public static final String TTY_FG_Yellow = "\u001b[33m";
    public static final String TTY_FG_Blue = "\u001b[34m";
    public static final String TTY_FG_Magenta = "\u001b[35m";
    public static final String TTY_FG_Cyan = "\u001b[36m";
    public static final String TTY_FG_White = "\u001b[37m";
    public static final String TTY_BG_Black = "\u001b[40m";
    public static final String TTY_BG_Red = "\u001b[41m";
    public static final String TTY_BG_Green = "\u001b[42m";
    public static final String TTY_BG_Yellow = "\u001b[43m";
    public static final String TTY_BG_Blue = "\u001b[44m";
    public static final String TTY_BG_Magenta = "\u001b[45m";
    public static final String TTY_BG_Cyan = "\u001b[46m";
    public static final String TTY_BG_White = "\u001b[47m";
    public static String PROMPT = "\u001b[0m\u001b[1m[openejb]$ \u001b[0m";

    public void init(Properties props) throws Exception {
        this.props = props;
    }

    protected void exec(InputStream input, PrintStream out) {
        DataInputStream in = new DataInputStream(input);
        while (!this.stop) {
            this.prompt(in, out);
        }
    }

    protected void prompt(DataInputStream in, PrintStream out) {
        try {
            Command cmd;
            out.print(PROMPT);
            out.flush();
            String commandline = in.readLine();
            this.logger.debug("command: " + commandline);
            commandline = commandline.trim();
            if (commandline.length() < 1) {
                return;
            }
            String command = commandline;
            Command.Arguments args = null;
            int spacePosition = commandline.indexOf(32);
            int tabPosition = commandline.indexOf(9);
            if (spacePosition != -1 || tabPosition != -1) {
                int cutPosition = spacePosition > tabPosition ? spacePosition : tabPosition;
                command = commandline.substring(0, cutPosition);
                args = new Command.Arguments(commandline.substring(cutPosition + 1));
            }
            if ((cmd = Command.getCommand(command)) == null) {
                out.print(command);
                out.println(": command not found");
            } else {
                cmd.exec(args, in, out);
            }
        }
        catch (UnsupportedOperationException e) {
            this.stop = true;
        }
        catch (Throwable e) {
            e.printStackTrace(new PrintStream(out));
            this.stop = true;
        }
    }

    protected void badCommand(DataInputStream in, PrintStream out) throws IOException {
    }
}

