/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import org.openejb.util.FileUtils;
import sun.misc.URLClassPath;

public class ClasspathUtils {
    private static Loader tomcatLoader = new ClasspathUtils().new TomcatLoader();
    private static Loader webappLoader = new ClasspathUtils().new WebAppLoader();
    private static Loader sysLoader = new ClasspathUtils().new SystemLoader();
    private static Loader ctxLoader = new ClasspathUtils().new ContextLoader();
    static /* synthetic */ Class class$java$net$URLClassLoader;
    static /* synthetic */ Class class$java$lang$String;

    public static void addJarToPath(String jar) throws Exception {
        ClasspathUtils.addJarToPath(FileUtils.getHome().getFile(jar));
    }

    public static void addJarToPath(File jar) throws Exception {
        ClasspathUtils.addJarToPath(jar.toURL());
    }

    public static void addJarToPath(URL jar) throws Exception {
        ClasspathUtils.getLoader().addJarToPath(jar);
    }

    public static void addJarToPath(String jar, String loaderName) throws Exception {
        ClasspathUtils.addJarToPath(FileUtils.getHome().getFile(jar), loaderName);
    }

    public static void addJarToPath(File jar, String loaderName) throws Exception {
        ClasspathUtils.addJarToPath(jar.toURL(), loaderName);
    }

    public static void addJarToPath(URL jar, String loaderName) throws Exception {
        ClasspathUtils.getLoader(loaderName).addJarToPath(jar);
    }

    public static void addJarsToPath(String dir) throws Exception {
        ClasspathUtils.addJarsToPath(FileUtils.getHome().getDirectory(dir));
    }

    public static void addJarsToPath(String dir, String loaderName, Hashtable env) throws Exception {
        File dirAtHome = FileUtils.getBase(env).getDirectory(dir);
        if (dirAtHome != null && dirAtHome.exists()) {
            ClasspathUtils.addJarsToPath(dirAtHome, loaderName);
        } else {
            ClasspathUtils.addJarsToPath(FileUtils.getHome(env).getDirectory(dir), loaderName);
        }
    }

    public static void addJarsToPath(File dir) throws Exception {
        if (dir == null) {
            return;
        }
        ClasspathUtils.getLoader().addJarsToPath(dir);
    }

    public static void addJarsToPath(String dir, String loaderName) throws Exception {
        ClasspathUtils.addJarsToPath(dir, loaderName, System.getProperties());
    }

    public static void addJarsToPath(File dir, String loaderName) throws Exception {
        ClasspathUtils.getLoader(loaderName).addJarsToPath(dir);
    }

    public static void addJarToSystemPath(String jar) throws Exception {
        ClasspathUtils.addJarToSystemPath(FileUtils.getHome().getFile(jar));
    }

    public static void addJarToSystemPath(File jar) throws Exception {
        ClasspathUtils.addJarToSystemPath(jar.toURL());
    }

    public static void addJarToSystemPath(URL jar) throws Exception {
    }

    protected static Loader getLoader() {
        String name = ClasspathUtils.getContextClassLoader().getClass().getName();
        if (name.equals("org.apache.catalina.loader.WebappClassLoader")) {
            return webappLoader;
        }
        if (name.startsWith("org.apache.catalina.loader")) {
            return tomcatLoader;
        }
        if (name.startsWith("org.apache.jasper.servlet")) {
            return tomcatLoader;
        }
        if (name.startsWith("sun.misc.Launcher")) {
            return sysLoader;
        }
        return ctxLoader;
    }

    protected static Loader getLoader(String name) {
        if (name.equalsIgnoreCase("tomcat")) {
            return tomcatLoader;
        }
        if (name.equalsIgnoreCase("tomcat-webapp")) {
            return webappLoader;
        }
        if (name.equalsIgnoreCase("bootstrap")) {
            return sysLoader;
        }
        if (name.equalsIgnoreCase("system")) {
            return sysLoader;
        }
        if (name.equalsIgnoreCase("thread")) {
            return ctxLoader;
        }
        if (name.equalsIgnoreCase("context")) {
            return ctxLoader;
        }
        return ctxLoader;
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static void rebuildJavaClassPathVariable() throws Exception {
    }

    class WebAppLoader
    extends TomcatLoader {
        ClassLoader webappLoader;

        WebAppLoader() {
        }

        protected ClassLoader getCommonLoader() {
            if (this.webappLoader == null) {
                this.webappLoader = ClasspathUtils.getContextClassLoader();
            }
            return this.webappLoader;
        }
    }

    class TomcatLoader
    extends BasicURLLoader {
        private ClassLoader tomcatLoader;
        private Method addRepositoryMethod;

        TomcatLoader() {
        }

        public void addJarsToPath(File dir) throws Exception {
            String[] jarNames = dir.list(new FilenameFilter(this){
                private final /* synthetic */ TomcatLoader this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }
            });
            if (jarNames == null) {
                return;
            }
            for (int j = 0; j < jarNames.length; ++j) {
                this.addJarToPath(new File(dir, jarNames[j]).toURL());
            }
            this.rebuild();
        }

        public void addJarToPath(URL jar) throws Exception {
            this._addJarToPath(jar);
            this.rebuild();
        }

        public void _addJarToPath(URL jar) throws Exception {
            String path = jar.toExternalForm();
            this.addRepository(path);
        }

        public void addRepository(String path) throws Exception {
            this.getAddRepositoryMethod().invoke((Object)this.getCommonLoader(), path);
        }

        private void rebuild() {
            try {
                URLClassPath cp = this.getURLClassPath((URLClassLoader)this.getCommonLoader());
                URL[] urls = cp.getURLs();
                if (urls.length < 1) {
                    return;
                }
                StringBuffer path = new StringBuffer(urls.length * 32);
                File s = new File(urls[0].getFile());
                path.append(s.getPath());
                for (int i = 1; i < urls.length; ++i) {
                    path.append(File.pathSeparator);
                    s = new File(urls[i].getFile());
                    path.append(s.getPath());
                }
                System.setProperty("java.class.path", path.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected ClassLoader getCommonLoader() {
            if (this.tomcatLoader == null) {
                this.tomcatLoader = this.getCommonLoader(ClasspathUtils.getContextClassLoader()).getParent();
            }
            return this.tomcatLoader;
        }

        private ClassLoader getCommonLoader(ClassLoader loader) {
            if (loader.getClass().getName().equals("org.apache.catalina.loader.StandardClassLoader")) {
                return loader;
            }
            return this.getCommonLoader(loader.getParent());
        }

        private Method getAddRepositoryMethod() throws Exception {
            if (this.addRepositoryMethod == null) {
                Class<?> clazz = this.getCommonLoader().getClass();
                this.addRepositoryMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(this, clazz){
                    private final /* synthetic */ Class val$clazz;
                    private final /* synthetic */ TomcatLoader this$1;
                    {
                        this.this$1 = this$1;
                        this.val$clazz = val$clazz;
                    }

                    public Object run() {
                        Method method = null;
                        try {
                            method = this.val$clazz.getDeclaredMethod("addRepository", class$java$lang$String == null ? (class$java$lang$String = ClasspathUtils.class$("java.lang.String")) : class$java$lang$String);
                            method.setAccessible(true);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        return method;
                    }
                });
            }
            return this.addRepositoryMethod;
        }
    }

    class ContextLoader
    extends BasicURLLoader {
        ContextLoader() {
        }

        public void addJarsToPath(File dir) throws Exception {
            ClassLoader contextClassLoader = ClasspathUtils.getContextClassLoader();
            if (contextClassLoader instanceof URLClassLoader) {
                URLClassLoader loader = (URLClassLoader)contextClassLoader;
                this.addJarsToPath(dir, loader);
            }
        }

        public void addJarToPath(URL jar) throws Exception {
            ClassLoader contextClassLoader = ClasspathUtils.getContextClassLoader();
            if (contextClassLoader instanceof URLClassLoader) {
                URLClassLoader loader = (URLClassLoader)contextClassLoader;
                this.addJarToPath(jar, loader);
            }
        }
    }

    class SystemLoader
    extends BasicURLLoader {
        private URLClassLoader sysLoader;

        SystemLoader() {
        }

        public void addJarsToPath(File dir) throws Exception {
            this.addJarsToPath(dir, this.getSystemLoader());
            this.rebuildJavaClassPathVariable();
        }

        public void addJarToPath(URL jar) throws Exception {
            this.addJarToPath(jar, this.getSystemLoader());
            this.rebuildJavaClassPathVariable();
        }

        private URLClassLoader getSystemLoader() throws Exception {
            if (this.sysLoader == null) {
                this.sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            }
            return this.sysLoader;
        }

        private void rebuildJavaClassPathVariable() throws Exception {
            URLClassPath cp = this.getURLClassPath(this.getSystemLoader());
            URL[] urls = cp.getURLs();
            if (urls.length < 1) {
                return;
            }
            StringBuffer path = new StringBuffer(urls.length * 32);
            File s = new File(urls[0].getFile());
            path.append(s.getPath());
            for (int i = 1; i < urls.length; ++i) {
                path.append(File.pathSeparator);
                s = new File(urls[i].getFile());
                path.append(s.getPath());
            }
            try {
                System.setProperty("java.class.path", path.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    class BasicURLLoader
    implements Loader {
        private Field ucpField;

        BasicURLLoader() {
        }

        public void addJarsToPath(File dir) throws Exception {
        }

        public void addJarToPath(URL jar) throws Exception {
        }

        protected void addJarToPath(URL jar, URLClassLoader loader) throws Exception {
            this.getURLClassPath(loader).addURL(jar);
        }

        protected void addJarsToPath(File dir, URLClassLoader loader) throws Exception {
            String[] jarNames = dir.list(new FilenameFilter(this){
                private final /* synthetic */ BasicURLLoader this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }
            });
            URL[] jars = new URL[jarNames.length];
            for (int j = 0; j < jarNames.length; ++j) {
                jars[j] = new File(dir, jarNames[j]).toURL();
            }
            URLClassPath path = this.getURLClassPath(loader);
            for (int i = 0; i < jars.length; ++i) {
                path.addURL(jars[i]);
            }
        }

        protected URLClassPath getURLClassPath(URLClassLoader loader) throws Exception {
            return (URLClassPath)this.getUcpField().get(loader);
        }

        private Field getUcpField() throws Exception {
            if (this.ucpField == null) {
                this.ucpField = (Field)AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ BasicURLLoader this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object run() {
                        Field ucp = null;
                        try {
                            ucp = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = ClasspathUtils.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredField("ucp");
                            ucp.setAccessible(true);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        return ucp;
                    }
                });
            }
            return this.ucpField;
        }
    }

    static interface Loader {
        public void addJarsToPath(File var1) throws Exception;

        public void addJarToPath(URL var1) throws Exception;
    }
}

