/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import org.openejb.OpenEJBException;

public class FileUtils {
    private static final Random _random = new Random();
    private static FileUtils openejbHomeUtils = new FileUtils("openejb.home", "user.dir");
    private static FileUtils openejbBaseUtils = new FileUtils("openejb.base", "openejb.home");
    private File home;

    private FileUtils(String homeDir, String defaultDir) {
        this(homeDir, defaultDir, System.getProperties());
    }

    private FileUtils(String homeDir, String defaultDir, Hashtable env) {
        String homePath = null;
        try {
            homePath = (String)env.get(homeDir);
            if (homePath == null) {
                homePath = (String)env.get(defaultDir);
            }
            if (homePath == null) {
                homePath = System.getProperty("user.dir");
            }
            this.home = new File(homePath);
            if (!this.home.exists() || this.home.exists() && !this.home.isDirectory()) {
                homePath = System.getProperty("user.dir");
                this.home = new File(homePath);
            }
            this.home = this.home.getAbsoluteFile();
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }

    public static FileUtils getBase() {
        return openejbBaseUtils;
    }

    public static FileUtils getBase(Hashtable env) {
        return new FileUtils("openejb.base", "openejb.home", env);
    }

    public static FileUtils getHome() {
        return openejbHomeUtils;
    }

    public static FileUtils getHome(Hashtable env) {
        return new FileUtils("openejb.home", "user.dir", env);
    }

    public File getDirectory(String path) throws IOException {
        return this.getDirectory(path, false);
    }

    public File getDirectory(String path, boolean create) throws IOException {
        File dir;
        block5: {
            dir = null;
            dir = new File(this.home, path);
            if (!(dir = dir.getCanonicalFile()).exists() && create) {
                try {
                    if (!dir.mkdirs()) {
                        throw new IOException("Cannot create the directory " + dir.getPath());
                    }
                    break block5;
                }
                catch (SecurityException e) {
                    throw new IOException("Permission denied: Cannot create the directory " + dir.getPath() + " : " + e.getMessage());
                }
            }
            if (dir.exists() && !dir.isDirectory()) {
                throw new IOException("The path specified is not a valid directory: " + dir.getPath());
            }
        }
        return dir;
    }

    public File getDirectory() {
        return this.home;
    }

    public void setDirectory(File dir) {
        this.home = dir;
    }

    public File getFile(String path) throws FileNotFoundException, IOException {
        return this.getFile(path, true);
    }

    public File getFile(String path, boolean validate) throws FileNotFoundException, IOException {
        File file = null;
        file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.home, path);
        }
        if (validate && !file.exists()) {
            throw new FileNotFoundException("The path specified is not a valid file: " + file.getPath());
        }
        if (validate && file.isDirectory()) {
            throw new FileNotFoundException("The path specified is a directory, not a file: " + file.getPath());
        }
        return file;
    }

    public static File createTempDirectory(String pathPrefix) throws IOException {
        for (int maxAttempts = 100; maxAttempts > 0; --maxAttempts) {
            String path = pathPrefix + _random.nextLong();
            File tmpDir = new File(path);
            if (tmpDir.exists()) continue;
            tmpDir.mkdir();
            return tmpDir;
        }
        throw new IOException("Can't create temporary directory.");
    }

    public static File createTempDirectory() throws IOException {
        String prefix = System.getProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "openejb";
        return FileUtils.createTempDirectory(prefix);
    }

    public static void copyFile(File destination, File source) throws IOException {
        FileUtils.copyFile(destination, source, false);
    }

    public static void copyFile(File destination, File source, boolean deleteSourceFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            in.close();
            out.close();
        }
        if (deleteSourceFile) {
            source.delete();
        }
    }

    public static String getAbsolutePath(String path, String secondaryPath, Properties props, boolean create) throws OpenEJBException {
        File file = null;
        if (path != null) {
            file = new File(path);
            if (file != null && file.exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
            try {
                file = FileUtils.getBase(props).getFile(path);
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                file = FileUtils.getHome(props).getFile(path);
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        try {
            try {
                file = FileUtils.getBase(props).getFile(secondaryPath);
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException ignored) {
                // empty catch block
            }
            try {
                file = FileUtils.getHome(props).getFile(secondaryPath);
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException ignored) {
                // empty catch block
            }
            if (create) {
                File confDir = FileUtils.getBase(props).getDirectory("conf", true);
                file = FileUtils.createConfig(new File(confDir, secondaryPath));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OpenEJBException("Could not locate config file: ", e);
        }
        return file == null ? null : file.getAbsolutePath();
    }

    private static File createConfig(File file) throws IOException {
        try {
            URL defaultConfig = new URL("resource:/" + file.getName());
            InputStream in = defaultConfig.openStream();
            FileOutputStream out = new FileOutputStream(file);
            int b = in.read();
            while (b != -1) {
                out.write(b);
                b = in.read();
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }
}

