/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.jar.JarFile;
import org.openejb.OpenEJBException;
import org.openejb.util.Messages;
import org.openejb.util.urlhandler.resource.Handler;
import sun.tools.jar.Main;

public class JarUtils {
    private static Messages messages = new Messages("org.openejb.util.resources");
    private static boolean alreadySet;
    static /* synthetic */ Class class$java$net$URL;

    public static void setHandlerSystemProperty() {
        if (!alreadySet) {
            Hashtable urlHandlers = (Hashtable)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Field handlers = null;
                    try {
                        handlers = (class$java$net$URL == null ? (class$java$net$URL = JarUtils.class$("java.net.URL")) : class$java$net$URL).getDeclaredField("handlers");
                        handlers.setAccessible(true);
                        return handlers.get(null);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        return null;
                    }
                }
            });
            urlHandlers.put("resource", new Handler());
            alreadySet = true;
        }
    }

    public static File getJarContaining(String path) throws OpenEJBException {
        File jarFile = null;
        try {
            URL url = new URL("resource:/" + path);
            String jarPath = null;
            if (url.getProtocol().compareTo("resource") == 0) {
                String resource = url.getFile().substring(1);
                url = JarUtils.getContextClassLoader().getResource(resource);
                if (url == null) {
                    throw new OpenEJBException("Could not locate a jar containing the path " + path);
                }
            }
            if (url != null) {
                jarPath = url.getFile();
                jarPath = jarPath.substring(0, jarPath.indexOf(33));
                jarPath = jarPath.substring("file:".length());
            }
            jarFile = new File(jarPath);
            jarFile = jarFile.getAbsoluteFile();
        }
        catch (Exception e) {
            throw new OpenEJBException("Could not locate a jar containing the path " + path, e);
        }
        return jarFile;
    }

    public static void addFileToJar(String jarFile, String file) throws OpenEJBException {
        ByteArrayOutputStream errorBytes = new ByteArrayOutputStream();
        PrintStream newErr = new PrintStream(errorBytes);
        PrintStream oldErr = System.err;
        System.setErr(newErr);
        Main jarTool = new Main(newErr, newErr, "config_utils");
        String[] args = new String[]{"uf", jarFile, file};
        jarTool.run(args);
        System.setErr(oldErr);
        try {
            errorBytes.close();
            newErr.close();
        }
        catch (Exception e) {
            throw new OpenEJBException(messages.format("file.0020", jarFile, e.getLocalizedMessage()));
        }
        String error = new String(errorBytes.toByteArray());
        if (error.indexOf("java.io.IOException") != -1) {
            int begin = error.indexOf(58) + 1;
            int end = error.indexOf(10);
            String message = error.substring(begin, end);
            throw new OpenEJBException(messages.format("file.0003", file, jarFile, message));
        }
    }

    public static JarFile getJarFile(String jarFile) throws OpenEJBException {
        JarFile jar = null;
        try {
            File file = new File(jarFile);
            jar = new JarFile(file);
        }
        catch (FileNotFoundException e) {
            throw new OpenEJBException(messages.format("file.0001", jarFile, e.getLocalizedMessage()));
        }
        catch (IOException e) {
            throw new OpenEJBException(messages.format("file.0002", jarFile, e.getLocalizedMessage()));
        }
        return jar;
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static {
        JarUtils.setHandlerSystemProperty();
        alreadySet = false;
    }
}

