/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openejb.util.FileUtils;

public final class Launcher {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            Launcher.printHelp();
            System.exit(-1);
        }
        StringBuffer classpath = new StringBuffer();
        FileUtils home = FileUtils.getHome();
        try {
            File dir = home.getDirectory("lib");
            Launcher.appendJarsToClasspath(classpath, Launcher.listDirectory(dir));
        }
        catch (IOException e) {
            System.out.println("[ERROR] Unable to add jars from 'lib' directory to classpath.");
        }
        classpath.append(System.getProperty("java.class.path"));
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("java");
        cmd.add("-classpath");
        cmd.add(classpath.toString());
        cmd.addAll(Launcher.getVmParameters());
        boolean wait = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-nowait")) {
                wait = false;
                continue;
            }
            cmd.add(args[i]);
        }
        Process process = null;
        try {
            try {
                Runtime rt = Runtime.getRuntime();
                process = rt.exec(cmd.toArray(new String[0]));
                StreamGrabber stderr = new StreamGrabber(process.getErrorStream(), System.err);
                StreamGrabber stdout = new StreamGrabber(process.getInputStream(), System.out);
                stderr.setName("Subprocess-STDERR");
                stdout.setName("Subprocess-STDOUT");
                stderr.setDaemon(true);
                stderr.start();
                stdout.setDaemon(true);
                stdout.start();
                rt.addShutdownHook(new KillProcessShutdownHook(process));
                if (wait) {
                    process.waitFor();
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Could not start the executable: " + args[0], t);
            }
            Object var10_12 = null;
            if (!wait) return;
            if (process == null) return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!wait) throw throwable;
            if (process == null) throw throwable;
            try {
                process.getErrorStream().close();
                process.getOutputStream().close();
                process.getInputStream().close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        process.getErrorStream().close();
        process.getOutputStream().close();
        process.getInputStream().close();
        return;
    }

    public static ArrayList getVmParameters() {
        ArrayList<String> options = new ArrayList<String>();
        Set<Map.Entry<Object, Object>> set = System.getProperties().entrySet();
        Iterator<Map.Entry<Object, Object>> iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            if (!entry.getKey().toString().startsWith("openejb")) continue;
            options.add("-D" + entry.getKey() + "=" + entry.getValue());
        }
        return options;
    }

    private static File[] listDirectory(File dir) {
        return dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
    }

    private static void appendJarsToClasspath(StringBuffer classpath, File[] jars) {
        for (int i = 0; i < jars.length; ++i) {
            classpath.append(jars[i].getAbsolutePath());
            classpath.append(File.pathSeparator);
        }
    }

    public static final void printHelp() {
        System.err.println("No class specified");
        System.err.println("exiting...");
    }

    private static final class KillProcessShutdownHook
    extends Thread {
        Process process;

        public KillProcessShutdownHook(Process process) {
            this.process = process;
        }

        public void run() {
            this.process.destroy();
        }
    }

    private static final class StreamGrabber
    extends Thread {
        InputStream is;
        OutputStream os;

        public StreamGrabber(InputStream is, OutputStream os) {
            this.is = is;
            this.os = os;
        }

        public void run() {
            BufferedInputStream in = new BufferedInputStream(this.is);
            try {
                int i;
                while ((i = in.read()) != -1) {
                    this.os.write(i);
                }
                this.os.flush();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

