/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.openejb.util.FileUtils;
import org.openejb.util.Messages;

public class Logger {
    protected static HashMap _loggers = new HashMap();
    protected Category _logger = null;
    public I18N i18n = null;
    private static Properties props;

    public static void initialize(Properties props) {
        Log4jConfigUtils log4j = new Log4jConfigUtils(props);
        log4j.configure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getInstance(String category, String resourceName) {
        Class clazz;
        HashMap<String, Logger> bundles = (HashMap<String, Logger>)_loggers.get(category);
        Logger logger = null;
        if (bundles == null) {
            clazz = Logger.class;
            synchronized (clazz) {
                bundles = (HashMap)_loggers.get(category);
                if (bundles == null) {
                    bundles = new HashMap<String, Logger>();
                    _loggers.put(category, bundles);
                }
            }
        }
        if ((logger = (Logger)bundles.get(resourceName)) == null) {
            clazz = Logger.class;
            synchronized (clazz) {
                logger = (Logger)bundles.get(resourceName);
                if (logger == null) {
                    logger = new Logger(resourceName);
                    logger._logger = Category.getInstance((String)category);
                    bundles.put(resourceName, logger);
                }
            }
        }
        return logger;
    }

    protected Logger(String resourceName) {
        this.i18n = new I18N(resourceName);
    }

    public boolean isDebugEnabled() {
        return this._logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this._logger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this._logger.isEnabledFor((Priority)Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this._logger.isInfoEnabled();
    }

    public boolean isWarningEnabled() {
        return this._logger.isEnabledFor((Priority)Level.WARN);
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this._logger.debug((Object)message);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this._logger.debug((Object)message, t);
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this._logger.error((Object)message);
        }
    }

    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this._logger.error((Object)message, t);
        }
    }

    public void fatal(String message) {
        if (this.isFatalEnabled()) {
            this._logger.fatal((Object)message);
        }
    }

    public void fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this._logger.fatal((Object)message, t);
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this._logger.info((Object)message);
        }
    }

    public void info(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this._logger.info((Object)message, t);
        }
    }

    public void warning(String message) {
        if (this.isWarningEnabled()) {
            this._logger.warn((Object)message);
        }
    }

    public void warning(String message, Throwable t) {
        if (this.isWarningEnabled()) {
            this._logger.warn((Object)message, t);
        }
    }

    static class Log4jConfigUtils {
        Properties props;

        public Log4jConfigUtils(Properties props) {
            this.props = props;
        }

        public void configure() {
            String config = this.props.getProperty("log4j.configuration");
            if (config == null) {
                config = "conf/logging.conf";
            }
            try {
                config = FileUtils.getAbsolutePath(config, "conf/default.logging.conf", this.props, false);
                Properties log4jProps = this.loadProperties(config);
                PropertyConfigurator.configure((Properties)this.filterProperties(log4jProps));
            }
            catch (Exception e) {
                System.err.println("Failed to configure log4j. " + e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Properties loadProperties(String file) throws Exception {
            Properties props = new Properties();
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(file);
                props.load(fin);
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
            }
            return props;
        }

        public Properties filterProperties(Properties log4jProps) {
            Object[] names = log4jProps.keySet().toArray();
            for (int i = 0; i < names.length; ++i) {
                String name = (String)names[i];
                if (!name.endsWith(".File")) continue;
                String path = log4jProps.getProperty(name);
                try {
                    File file = FileUtils.getBase(this.props).getFile(path, false);
                    if (!file.getParentFile().exists()) {
                        file = FileUtils.getHome(this.props).getFile(path, false);
                    }
                    path = file.getPath();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                log4jProps.setProperty(name, path);
            }
            return log4jProps;
        }
    }

    public class I18N {
        protected Messages _messages = null;

        protected I18N(String resourceName) {
            this._messages = new Messages(resourceName);
        }

        public void info(String code) {
            if (Logger.this.isInfoEnabled()) {
                Logger.this._logger.info((Object)this._messages.message(code));
            }
        }

        public void info(String code, Throwable t) {
            if (Logger.this.isInfoEnabled()) {
                Logger.this._logger.info((Object)this._messages.message(code), t);
            }
        }

        public void info(String code, Object arg0) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0};
                this.info(code, args);
            }
        }

        public void info(String code, Throwable t, Object arg0) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0};
                this.info(code, t, args);
            }
        }

        public void info(String code, Object arg0, Object arg1) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0, arg1};
                this.info(code, args);
            }
        }

        public void info(String code, Throwable t, Object arg0, Object arg1) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0, arg1};
                this.info(code, t, args);
            }
        }

        public void info(String code, Object arg0, Object arg1, Object arg2) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2};
                this.info(code, args);
            }
        }

        public void info(String code, Throwable t, Object arg0, Object arg1, Object arg2) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2};
                this.info(code, t, args);
            }
        }

        public void info(String code, Object arg0, Object arg1, Object arg2, Object arg3) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3};
                this.info(code, args);
            }
        }

        public void info(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3};
                this.info(code, t, args);
            }
        }

        public void info(String code, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
                this.info(code, args);
            }
        }

        public void info(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
                this.info(code, t, args);
            }
        }

        public void info(String code, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4, arg5};
                this.info(code, args);
            }
        }

        public void info(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            if (Logger.this.isInfoEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4, arg5};
                this.info(code, t, args);
            }
        }

        public void info(String code, Object[] args) {
            Logger.this._logger.info((Object)this._messages.format(code, args));
        }

        public void info(String code, Throwable t, Object[] args) {
            Logger.this._logger.info((Object)this._messages.format(code, args), t);
        }

        public void warning(String code) {
            if (Logger.this.isWarningEnabled()) {
                Logger.this._logger.warn((Object)this._messages.message(code));
            }
        }

        public void warning(String code, Throwable t) {
            if (Logger.this.isWarningEnabled()) {
                Logger.this._logger.warn((Object)this._messages.message(code), t);
            }
        }

        public void warning(String code, Object arg0) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0};
                this.warning(code, args);
            }
        }

        public void warning(String code, Throwable t, Object arg0) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0};
                this.warning(code, t, args);
            }
        }

        public void warning(String code, Object arg0, Object arg1) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0, arg1};
                this.warning(code, args);
            }
        }

        public void warning(String code, Throwable t, Object arg0, Object arg1) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0, arg1};
                this.warning(code, t, args);
            }
        }

        public void warning(String code, Object arg0, Object arg1, Object arg2) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2};
                this.warning(code, args);
            }
        }

        public void warning(String code, Throwable t, Object arg0, Object arg1, Object arg2) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2};
                this.warning(code, t, args);
            }
        }

        public void warning(String code, Object arg0, Object arg1, Object arg2, Object arg3) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3};
                this.warning(code, args);
            }
        }

        public void warning(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3};
                this.warning(code, t, args);
            }
        }

        public void warning(String code, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
                this.warning(code, args);
            }
        }

        public void warning(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
                this.warning(code, t, args);
            }
        }

        public void warning(String code, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4, arg5};
                this.warning(code, args);
            }
        }

        public void warning(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            if (Logger.this.isWarningEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4, arg5};
                this.warning(code, t, args);
            }
        }

        public void warning(String code, Object[] args) {
            Logger.this._logger.warn((Object)this._messages.format(code, args));
        }

        public void warning(String code, Throwable t, Object[] args) {
            Logger.this._logger.warn((Object)this._messages.format(code, args), t);
        }

        public void error(String code) {
            if (Logger.this.isErrorEnabled()) {
                Logger.this._logger.error((Object)this._messages.message(code));
            }
        }

        public void error(String code, Throwable t) {
            if (Logger.this.isErrorEnabled()) {
                Logger.this._logger.error((Object)this._messages.message(code), t);
            }
        }

        public void error(String code, Object arg0) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0};
                this.error(code, args);
            }
        }

        public void error(String code, Throwable t, Object arg0) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0};
                this.error(code, t, args);
            }
        }

        public void error(String code, Object arg0, Object arg1) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0, arg1};
                this.error(code, args);
            }
        }

        public void error(String code, Throwable t, Object arg0, Object arg1) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0, arg1};
                this.error(code, t, args);
            }
        }

        public void error(String code, Object arg0, Object arg1, Object arg2) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2};
                this.error(code, args);
            }
        }

        public void error(String code, Throwable t, Object arg0, Object arg1, Object arg2) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2};
                this.error(code, t, args);
            }
        }

        public void error(String code, Object arg0, Object arg1, Object arg2, Object arg3) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3};
                this.error(code, args);
            }
        }

        public void error(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3};
                this.error(code, t, args);
            }
        }

        public void error(String code, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
                this.error(code, args);
            }
        }

        public void error(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
                this.error(code, t, args);
            }
        }

        public void error(String code, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4, arg5};
                this.error(code, args);
            }
        }

        public void error(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            if (Logger.this.isErrorEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4, arg5};
                this.error(code, t, args);
            }
        }

        public void error(String code, Object[] args) {
            Logger.this._logger.error((Object)this._messages.format(code, args));
        }

        public void error(String code, Throwable t, Object[] args) {
            Logger.this._logger.error((Object)this._messages.format(code, args), t);
        }

        public void fatal(String code) {
            Logger.this._logger.fatal((Object)this._messages.message(code));
        }

        public void fatal(String code, Throwable t) {
            Logger.this._logger.fatal((Object)this._messages.message(code), t);
        }

        public void fatal(String code, Object arg0) {
            Object[] args = new Object[]{arg0};
            this.fatal(code, args);
        }

        public void fatal(String code, Throwable t, Object arg0) {
            Object[] args = new Object[]{arg0};
            this.fatal(code, t, args);
        }

        public void fatal(String code, Object arg0, Object arg1) {
            Object[] args = new Object[]{arg0, arg1};
            this.fatal(code, args);
        }

        public void fatal(String code, Throwable t, Object arg0, Object arg1) {
            Object[] args = new Object[]{arg0, arg1};
            this.fatal(code, t, args);
        }

        public void fatal(String code, Object arg0, Object arg1, Object arg2) {
            Object[] args = new Object[]{arg0, arg1, arg2};
            this.fatal(code, args);
        }

        public void fatal(String code, Throwable t, Object arg0, Object arg1, Object arg2) {
            Object[] args = new Object[]{arg0, arg1, arg2};
            this.fatal(code, t, args);
        }

        public void fatal(String code, Object arg0, Object arg1, Object arg2, Object arg3) {
            Object[] args = new Object[]{arg0, arg1, arg2, arg3};
            this.fatal(code, args);
        }

        public void fatal(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3) {
            Object[] args = new Object[]{arg0, arg1, arg2, arg3};
            this.fatal(code, t, args);
        }

        public void fatal(String code, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
            Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
            this.fatal(code, args);
        }

        public void fatal(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
            Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
            this.fatal(code, t, args);
        }

        public void fatal(String code, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4, arg5};
            this.fatal(code, args);
        }

        public void fatal(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4, arg5};
            this.fatal(code, t, args);
        }

        public void fatal(String code, Object[] args) {
            Logger.this._logger.fatal((Object)this._messages.format(code, args));
        }

        public void fatal(String code, Throwable t, Object[] args) {
            Logger.this._logger.fatal((Object)this._messages.format(code, args), t);
        }

        public void debug(String code) {
            if (Logger.this.isDebugEnabled()) {
                Logger.this._logger.debug((Object)this._messages.message(code));
            }
        }

        public void debug(String code, Throwable t) {
            if (Logger.this.isDebugEnabled()) {
                Logger.this._logger.debug((Object)this._messages.message(code), t);
            }
        }

        public void debug(String code, Object arg0) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0};
                this.debug(code, args);
            }
        }

        public void debug(String code, Throwable t, Object arg0) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0};
                this.debug(code, t, args);
            }
        }

        public void debug(String code, Object arg0, Object arg1) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0, arg1};
                this.debug(code, args);
            }
        }

        public void debug(String code, Throwable t, Object arg0, Object arg1) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0, arg1};
                this.debug(code, t, args);
            }
        }

        public void debug(String code, Object arg0, Object arg1, Object arg2) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2};
                this.debug(code, args);
            }
        }

        public void debug(String code, Throwable t, Object arg0, Object arg1, Object arg2) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2};
                this.debug(code, t, args);
            }
        }

        public void debug(String code, Object arg0, Object arg1, Object arg2, Object arg3) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3};
                this.debug(code, args);
            }
        }

        public void debug(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3};
                this.debug(code, t, args);
            }
        }

        public void debug(String code, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
                this.debug(code, args);
            }
        }

        public void debug(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
                this.debug(code, t, args);
            }
        }

        public void debug(String code, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4, arg5};
                this.debug(code, args);
            }
        }

        public void debug(String code, Throwable t, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            if (Logger.this.isDebugEnabled()) {
                Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4, arg5};
                this.debug(code, t, args);
            }
        }

        public void debug(String code, Object[] args) {
            Logger.this._logger.debug((Object)this._messages.format(code, args));
        }

        public void debug(String code, Throwable t, Object[] args) {
            Logger.this._logger.debug((Object)this._messages.format(code, args), t);
        }
    }
}

