/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class MemoryClassLoader
extends ClassLoader {
    private static final int BUFFER_SIZE = 1024;
    private HashMap classes = new HashMap();
    private HashMap others = new HashMap();

    public MemoryClassLoader(ClassLoader parent, JarFile file) {
        this(parent, new JarFile[]{file});
    }

    public MemoryClassLoader(ClassLoader parent, JarFile[] file) {
        super(parent);
        for (int i = 0; i < file.length; ++i) {
            this.addJar(file[i]);
            try {
                file[i].close();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public MemoryClassLoader(ClassLoader parent, JarInputStream stream) {
        this(parent, new JarInputStream[]{stream});
    }

    public MemoryClassLoader(ClassLoader parent, JarInputStream[] stream) {
        super(parent);
        for (int i = 0; i < stream.length; ++i) {
            this.addJar(stream[i]);
        }
    }

    public InputStream getResourceAsStream(String name) {
        byte[] buf;
        InputStream stream = this.getParent().getResourceAsStream(name);
        if (stream == null && (buf = (byte[])this.others.get(name)) != null) {
            stream = new ByteArrayInputStream(buf);
        }
        return stream;
    }

    public URL getResource(String name) {
        throw new Error("Not Yet Implemented!");
    }

    protected Enumeration findResources(String name) throws IOException {
        throw new Error("Not Yet Implemented!");
    }

    public boolean equals(Object o) {
        if (o instanceof MemoryClassLoader) {
            return ((MemoryClassLoader)o).getParent() == this.getParent();
        }
        return false;
    }

    public int hashCode() {
        return this.getParent().hashCode();
    }

    public Class findClass(String name) throws ClassNotFoundException {
        byte[] data = this.findClassData(name);
        if (data != null) {
            return this.defineClass(name, data, 0, data.length);
        }
        throw new ClassNotFoundException();
    }

    public void addJar(JarFile jar) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.getName().endsWith(".class")) {
                try {
                    this.addClassFile(jar, entry);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                this.addOtherFile(jar, entry);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addJar(JarInputStream stream) {
        byte[] buf = new byte[1024];
        try {
            JarEntry entry;
            while ((entry = stream.getNextJarEntry()) != null) {
                int count;
                ByteArrayOutputStream out;
                String name = entry.getName();
                int size = (int)entry.getSize();
                ByteArrayOutputStream byteArrayOutputStream = out = size >= 0 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream(1024);
                while ((count = stream.read(buf)) > -1) {
                    out.write(buf, 0, count);
                }
                out.close();
                if (name.endsWith(".class")) {
                    this.classes.put(MemoryClassLoader.getClassName(name), out.toByteArray());
                    continue;
                }
                this.others.put(name, out.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private byte[] findClassData(String name) {
        return (byte[])this.classes.remove(name);
    }

    private void addClassFile(JarFile jar, JarEntry entry) throws IOException {
        this.classes.put(MemoryClassLoader.getClassName(entry.getName()), MemoryClassLoader.getFileBytes(jar, entry));
    }

    private void addOtherFile(JarFile jar, JarEntry entry) throws IOException {
        this.others.put(entry.getName(), MemoryClassLoader.getFileBytes(jar, entry));
    }

    private static String getClassName(String fileName) {
        return fileName.substring(0, fileName.length() - 6).replace('/', '.');
    }

    private static byte[] getFileBytes(JarFile jar, JarEntry entry) throws IOException {
        int count;
        ByteArrayOutputStream stream = new ByteArrayOutputStream((int)entry.getSize());
        byte[] buf = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(jar.getInputStream(entry));
        while ((count = in.read(buf)) > -1) {
            stream.write(buf, 0, count);
        }
        in.close();
        stream.close();
        return stream.toByteArray();
    }
}

