/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static Hashtable _rbBundles = new Hashtable();
    private static Hashtable _rbFormats = new Hashtable();
    private static Locale _globalLocale;
    private ResourceBundle _messages;
    private Hashtable _formats;
    private Locale _locale;
    private String _resourceName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Messages(String resourceName) {
        Class clazz = Messages.class;
        synchronized (clazz) {
            this._locale = _globalLocale;
            this._resourceName = resourceName + ".Messages";
            ResourceBundle rb = (ResourceBundle)_rbBundles.get(this._resourceName);
            if (rb == null) {
                this.init();
            } else {
                this._messages = rb;
                this._formats = (Hashtable)_rbFormats.get(this._resourceName);
            }
        }
    }

    protected void init() {
        try {
            this._messages = this._locale == null ? ResourceBundle.getBundle(this._resourceName) : ResourceBundle.getBundle(this._resourceName, this._locale);
        }
        catch (Exception except) {
            this._messages = new EmptyResourceBundle();
        }
        this._formats = new Hashtable();
        _rbBundles.put(this._resourceName, this._messages);
        _rbFormats.put(this._resourceName, this._formats);
    }

    public String format(String message, Object arg1) {
        return this.format(message, new Object[]{arg1});
    }

    public String format(String message, Object arg1, Object arg2) {
        return this.format(message, new Object[]{arg1, arg2});
    }

    public String format(String message, Object arg1, Object arg2, Object arg3) {
        return this.format(message, new Object[]{arg1, arg2, arg3});
    }

    public String format(String message, Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.format(message, new Object[]{arg1, arg2, arg3, arg4});
    }

    public String format(String message, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return this.format(message, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public String format(String message) {
        return this.message(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(String message, Object[] args) {
        if (this._locale != _globalLocale) {
            Class clazz = Messages.class;
            synchronized (clazz) {
                this.init();
            }
        }
        try {
            MessageFormat mf = (MessageFormat)this._formats.get(message);
            if (mf == null) {
                String msg;
                try {
                    msg = this._messages.getString(message);
                }
                catch (MissingResourceException except) {
                    return message;
                }
                mf = new MessageFormat(msg);
                this._formats.put(message, mf);
            }
            return mf.format(args);
        }
        catch (Exception except) {
            return "An internal error occured while processing message " + message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String message(String message) {
        if (this._locale != _globalLocale) {
            Class clazz = Messages.class;
            synchronized (clazz) {
                this.init();
            }
        }
        try {
            return this._messages.getString(message);
        }
        catch (MissingResourceException except) {
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale locale) {
        Class clazz = Messages.class;
        synchronized (clazz) {
            _globalLocale = locale;
            _rbBundles = new Hashtable();
            _rbFormats = new Hashtable();
        }
    }

    static {
        Messages.setLocale(Locale.getDefault());
    }

    private static final class EmptyResourceBundle
    extends ResourceBundle
    implements Enumeration {
        private EmptyResourceBundle() {
        }

        public Enumeration getKeys() {
            return this;
        }

        protected Object handleGetObject(String name) {
            return "[Missing message " + name + "]";
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

