/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util;

import java.util.Properties;
import org.openejb.OpenEJBException;
import org.openejb.util.OpenEJBErrorHandler;

public class SafeProperties {
    private String systemLocation;
    private Properties props;

    public SafeProperties(Properties props, String systemLocation) throws OpenEJBException {
        if (props == null) {
            OpenEJBErrorHandler.propertiesObjectIsNull(systemLocation);
        }
        this.props = props;
        this.systemLocation = systemLocation;
    }

    public String getProperty(String key) throws OpenEJBException {
        String value = this.props.getProperty(key);
        if (value == null) {
            OpenEJBErrorHandler.propertyNotFound(key, this.systemLocation + " properties object");
        }
        return value;
    }

    public String getProperty(String key, String defaultValue) throws OpenEJBException {
        String value = this.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int getPropertyAsInt(String key) throws OpenEJBException {
        int integer = 0;
        String value = this.getProperty(key);
        try {
            integer = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            OpenEJBErrorHandler.propertyValueIsIllegal(key, value);
        }
        return integer;
    }

    public int getPropertyAsInt(String key, int defaultValue) throws OpenEJBException {
        int integer = defaultValue;
        String value = this.getProperty(key, String.valueOf(defaultValue));
        try {
            integer = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            OpenEJBErrorHandler.propertyValueIsIllegal(key, value);
        }
        return integer;
    }

    public Integer getPropertyAsInteger(String key, Integer defaultValue) throws OpenEJBException {
        Integer integer = null;
        String value = this.getProperty(key, defaultValue.toString());
        try {
            integer = new Integer(value);
        }
        catch (NumberFormatException nfe) {
            OpenEJBErrorHandler.propertyValueIsIllegal(key, value);
        }
        return integer;
    }

    public Integer getPropertyAsInteger(String key) throws OpenEJBException {
        Integer integer = null;
        String value = this.getProperty(key);
        try {
            integer = new Integer(value);
        }
        catch (NumberFormatException nfe) {
            OpenEJBErrorHandler.propertyValueIsIllegal(key, value);
        }
        return integer;
    }

    public boolean getPropertyAsBoolean(String key) throws OpenEJBException {
        Object integer = null;
        String value = this.getProperty(key);
        return new Boolean(value);
    }

    public Boolean getPropertyAsBoolean(String key, Boolean defaultValue) throws OpenEJBException {
        Object integer = null;
        String value = this.getProperty(key, defaultValue.toString());
        return new Boolean(value);
    }
}

