/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;
import org.openejb.OpenEJBException;
import org.openejb.util.FileUtils;
import org.openejb.util.Messages;
import org.openejb.util.OpenEJBErrorHandler;
import org.openejb.util.SafeProperties;

public class SafeToolkit {
    private String systemLocation;
    protected static Messages messages = new Messages("org.openejb.util.resources");
    protected static HashMap codebases = new HashMap();
    protected static HashMap _tempcodebases = new HashMap();

    protected SafeToolkit(String systemLocation) {
        this.systemLocation = systemLocation;
    }

    public static SafeToolkit getToolkit(String systemLocation) {
        return new SafeToolkit(systemLocation);
    }

    public Class forName(String className) throws OpenEJBException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            OpenEJBErrorHandler.classNotFound(this.systemLocation, className);
        }
        return clazz;
    }

    public Class forName(String className, String codebase) throws OpenEJBException {
        ClassLoader cl = SafeToolkit.getContextClassLoader();
        if (codebase != null) {
            try {
                URL[] urlCodebase = new URL[]{new URL(codebase)};
                cl = new URLClassLoader(urlCodebase, cl);
            }
            catch (MalformedURLException mue) {
                OpenEJBErrorHandler.classCodebaseNotFound(this.systemLocation, className, codebase, mue);
            }
            catch (SecurityException se) {
                OpenEJBErrorHandler.classCodebaseNotFound(this.systemLocation, className, codebase, se);
            }
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException cnfe) {
            OpenEJBErrorHandler.classNotFound(this.systemLocation, className);
        }
        return clazz;
    }

    public Object newInstance(String className) throws OpenEJBException {
        return this.newInstance(this.forName(className));
    }

    public Object newInstance(String className, String codebase) throws OpenEJBException {
        return this.newInstance(this.forName(className, codebase));
    }

    public Object newInstance(Class clazz) throws OpenEJBException {
        Object instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (InstantiationException ie) {
            OpenEJBErrorHandler.classNotIntantiateable(this.systemLocation, clazz.getName());
        }
        catch (IllegalAccessException iae) {
            OpenEJBErrorHandler.classNotAccessible(this.systemLocation, clazz.getName());
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                OpenEJBErrorHandler.classNotIntantiateableFromCodebaseForUnknownReason(this.systemLocation, clazz.getName(), SafeToolkit.getCodebase((URLClassLoader)classLoader), exception.getClass().getName(), exception.getMessage());
            }
            OpenEJBErrorHandler.classNotIntantiateableForUnknownReason(this.systemLocation, clazz.getName(), exception.getClass().getName(), exception.getMessage());
        }
        return instance;
    }

    public SafeProperties getSafeProperties(Properties props) throws OpenEJBException {
        return new SafeProperties(props, this.systemLocation);
    }

    public static Class loadClass(String className, String codebase) throws OpenEJBException {
        return SafeToolkit.loadClass(className, codebase, true);
    }

    public static Class loadClass(String className, String codebase, boolean cache) throws OpenEJBException {
        ClassLoader cl = cache ? SafeToolkit.getCodebaseClassLoader(codebase) : SafeToolkit.getClassLoader(codebase);
        Class<?> clazz = null;
        try {
            clazz = cl.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new OpenEJBException(messages.format("cl0007", className, codebase));
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ClassLoader getCodebaseClassLoader(String codebase) throws OpenEJBException {
        ClassLoader cl;
        if (codebase == null) {
            codebase = "CLASSPATH";
        }
        if ((cl = (ClassLoader)codebases.get(codebase)) == null) {
            HashMap hashMap = codebases;
            synchronized (hashMap) {
                cl = (ClassLoader)codebases.get(codebase);
                if (cl == null) {
                    try {
                        URL[] urlCodebase = new URL[]{new URL("file", null, codebase)};
                        cl = new URLClassLoader(urlCodebase, SafeToolkit.class.getClassLoader());
                        codebases.put(codebase, cl);
                    }
                    catch (MalformedURLException mue) {
                        throw new OpenEJBException(messages.format("cl0001", codebase, mue.getMessage()));
                    }
                    catch (SecurityException se) {
                        throw new OpenEJBException(messages.format("cl0002", codebase, se.getMessage()));
                    }
                }
            }
        }
        return cl;
    }

    protected static ClassLoader getClassLoader(String codebase) throws OpenEJBException {
        URLClassLoader cl = null;
        try {
            URL[] urlCodebase = new URL[]{new URL("file", null, codebase)};
            cl = new URLClassLoader(urlCodebase, SafeToolkit.class.getClassLoader());
        }
        catch (MalformedURLException mue) {
            throw new OpenEJBException(messages.format("cl0001", codebase, mue.getMessage()));
        }
        catch (SecurityException se) {
            throw new OpenEJBException(messages.format("cl0002", codebase, se.getMessage()));
        }
        return cl;
    }

    private static String getCodebase(URLClassLoader urlClassLoader) {
        StringBuffer codebase = new StringBuffer();
        URL[] urlList = urlClassLoader.getURLs();
        codebase.append(urlList[0].toString());
        for (int i = 1; i < urlList.length; ++i) {
            codebase.append(';');
            codebase.append(urlList[i].toString());
        }
        return codebase.toString();
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static Class loadTempClass(String className, String codebase) throws OpenEJBException {
        return SafeToolkit.loadTempClass(className, codebase, true);
    }

    public static Class loadTempClass(String className, String codebase, boolean cache) throws OpenEJBException {
        ClassLoader cl = cache ? SafeToolkit.getCodebaseTempClassLoader(codebase) : SafeToolkit.getTempClassLoader(codebase);
        Class<?> clazz = null;
        try {
            clazz = cl.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new OpenEJBException(messages.format("cl0007", className, codebase));
        }
        return clazz;
    }

    public static void unloadTempCodebase(String codebase) {
        _tempcodebases.remove(codebase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ClassLoader getCodebaseTempClassLoader(String codebase) throws OpenEJBException {
        ClassLoader cl;
        if (codebase == null) {
            codebase = "CLASSPATH";
        }
        if ((cl = (ClassLoader)_tempcodebases.get(codebase)) == null) {
            HashMap hashMap = codebases;
            synchronized (hashMap) {
                cl = (ClassLoader)codebases.get(codebase);
                if (cl == null) {
                    try {
                        URL[] urlCodebase = new URL[]{SafeToolkit.createTempCopy(codebase).toURL()};
                        cl = new URLClassLoader(urlCodebase, SafeToolkit.class.getClassLoader());
                        _tempcodebases.put(codebase, cl);
                    }
                    catch (MalformedURLException mue) {
                        throw new OpenEJBException(messages.format("cl0001", codebase, mue.getMessage()));
                    }
                    catch (SecurityException se) {
                        throw new OpenEJBException(messages.format("cl0002", codebase, se.getMessage()));
                    }
                }
            }
        }
        return cl;
    }

    protected static ClassLoader getTempClassLoader(String codebase) throws OpenEJBException {
        URLClassLoader cl = null;
        try {
            URL[] urlCodebase = new URL[]{SafeToolkit.createTempCopy(codebase).toURL()};
            cl = new URLClassLoader(urlCodebase, SafeToolkit.class.getClassLoader());
        }
        catch (MalformedURLException mue) {
            throw new OpenEJBException(messages.format("cl0001", codebase, mue.getMessage()));
        }
        catch (SecurityException se) {
            throw new OpenEJBException(messages.format("cl0002", codebase, se.getMessage()));
        }
        return cl;
    }

    protected static File createTempCopy(String codebase) throws OpenEJBException {
        File file = null;
        try {
            File codebaseFile = new File(codebase);
            file = File.createTempFile("openejb_validate", ".jar", null);
            file.deleteOnExit();
            FileUtils.copyFile(file, codebaseFile);
        }
        catch (Exception e) {
            throw new OpenEJBException(messages.format("cl0002", codebase, e.getMessage()));
        }
        return file;
    }
}

