/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util.io;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.openejb.util.io.ClassDescriptor;
import org.openejb.util.io.ObjectOutputStream;

public class FieldDescriptor
implements Serializable,
Comparable {
    protected String typeString;
    protected String name;
    protected Field field;
    protected char typeCode;
    protected Class type;
    protected ClassDescriptor classDesc;

    public FieldDescriptor(Field field) {
        this.field = field;
        this.name = field.getName();
        this.type = field.getType();
        if (this.type.isPrimitive()) {
            if (this.type == Integer.TYPE) {
                this.typeCode = (char)73;
            } else if (this.type == Byte.TYPE) {
                this.typeCode = (char)66;
            } else if (this.type == Long.TYPE) {
                this.typeCode = (char)74;
            } else if (this.type == Float.TYPE) {
                this.typeCode = (char)70;
            } else if (this.type == Double.TYPE) {
                this.typeCode = (char)68;
            } else if (this.type == Short.TYPE) {
                this.typeCode = (char)83;
            } else if (this.type == Character.TYPE) {
                this.typeCode = (char)67;
            } else if (this.type == Boolean.TYPE) {
                this.typeCode = (char)90;
            } else if (this.type == Void.TYPE) {
                this.typeCode = (char)86;
            }
        } else if (this.type.isArray()) {
            this.typeCode = (char)91;
            this.typeString = ClassDescriptor.getSignature(this.type).toString().intern();
        } else {
            this.typeCode = (char)76;
            StringBuffer buf = new StringBuffer();
            buf.append(this.typeCode);
            buf.append(this.type.getName().replace('.', '/'));
            buf.append(';');
            this.typeString = buf.toString().intern();
        }
    }

    public FieldDescriptor(String name, Class type) {
    }

    public String getTypeString() {
        return this.typeString;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public char getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(char typeCode) {
        this.typeCode = typeCode;
    }

    public int compareTo(Object o) {
        boolean otherprim;
        FieldDescriptor f2 = (FieldDescriptor)o;
        boolean thisprim = this.typeString == null;
        boolean bl = otherprim = f2.typeString == null;
        if (thisprim != otherprim) {
            return thisprim ? -1 : 1;
        }
        return this.name.compareTo(f2.name);
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDesc;
    }

    public void setClassDescriptor(ClassDescriptor classDesc) {
        this.classDesc = classDesc;
    }

    public void writeDesc(ObjectOutputStream out) throws IOException {
        out.writeByte(this.typeCode);
        out.writeUTF(this.name);
        if (!this.type.isPrimitive()) {
            out.writeString(this.typeString);
        }
    }

    public void write(Object o, ObjectOutputStream out) throws IOException, InvalidClassException {
        if (this.field == null) {
            throw new InvalidClassException(this.classDesc.forClass().getName(), "Nonexistent field " + this.name);
        }
        try {
            switch (this.typeCode) {
                case 'B': {
                    out.writeByte(this.field.getByte(o));
                    break;
                }
                case 'C': {
                    out.writeChar(this.field.getChar(o));
                    break;
                }
                case 'I': {
                    out.writeInt(this.field.getInt(o));
                    break;
                }
                case 'Z': {
                    out.writeBoolean(this.field.getBoolean(o));
                    break;
                }
                case 'J': {
                    out.writeLong(this.field.getLong(o));
                    break;
                }
                case 'F': {
                    out.writeFloat(this.field.getFloat(o));
                    break;
                }
                case 'D': {
                    out.writeDouble(this.field.getDouble(o));
                    break;
                }
                case 'S': {
                    out.writeShort(this.field.getShort(o));
                    break;
                }
                case 'L': 
                case '[': {
                    out.writeObject(this.field.get(o));
                    break;
                }
                default: {
                    throw new InvalidClassException(this.classDesc.forClass().getName());
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new InvalidClassException(this.classDesc.forClass().getName(), e.getMessage());
        }
    }
}

