/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamConstants;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.openejb.util.ArrayStack;
import org.openejb.util.io.ClassDescriptor;
import org.openejb.util.io.FieldDescriptor;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private OutputStream out;
    private ArrayStack classDescStack;
    private byte[] buf = new byte[5000];
    private int count;
    private char[] utfCharBuf = new char[32];
    private ArrayList wireHandle2Object;
    private int nextWireOffset;
    private int[] wireHash2Handle;
    private int[] wireNextHandle;
    private int wireHashSizePower = 2;
    private int wireHashLoadFactor = 7;
    private int wireHashCapacity = (1 << this.wireHashSizePower) * this.wireHashLoadFactor;

    public ObjectOutputStream(OutputStream out) throws IOException {
        this.out = out;
        this.classDescStack = new ArrayStack();
    }

    public void reset() throws IOException {
        this.resetStream();
        this.count = 0;
    }

    public void serializeObject(Object obj, OutputStream out) throws NotSerializableException, IOException {
        this.out = out;
        this.serializeObject(obj);
    }

    public void serializeObject(Object obj) throws NotSerializableException, IOException {
        if (!Serializable.class.isAssignableFrom(obj.getClass()) && !Externalizable.class.isAssignableFrom(obj.getClass())) {
            throw new NotSerializableException(obj.getClass().getName());
        }
        this.reset();
        this.writeShort(-21267);
        this.writeShort(5);
        this.writeObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Object obj) throws IOException {
        ClassDescriptor superClassDesc;
        if (obj == null) {
            this.write(112);
            return;
        }
        Class<?> clazz = obj.getClass();
        ClassDescriptor classDesc = null;
        classDesc = clazz == ClassDescriptor.class ? (ClassDescriptor)obj : ClassDescriptor.lookupInternal(clazz);
        if (classDesc == null) {
            this.write(112);
            return;
        }
        int tmpInt = this.findWireOffset(obj);
        if (tmpInt >= 0) {
            this.write(113);
            this.write((tmpInt += 0x7E0000) >>> 24 & 0xFF);
            this.write(tmpInt >>> 16 & 0xFF);
            this.write(tmpInt >>> 8 & 0xFF);
            this.write(tmpInt >>> 0 & 0xFF);
            return;
        }
        if (obj instanceof Class) {
            this.write(118);
            this.write(114);
            this.writeUTF(classDesc.getName());
            long value = classDesc.getSerialVersionUID();
            this.write((int)(value >>> 56) & 0xFF);
            this.write((int)(value >>> 48) & 0xFF);
            this.write((int)(value >>> 40) & 0xFF);
            this.write((int)(value >>> 32) & 0xFF);
            this.write((int)(value >>> 24) & 0xFF);
            this.write((int)(value >>> 16) & 0xFF);
            this.write((int)(value >>> 8) & 0xFF);
            this.write((int)(value >>> 0) & 0xFF);
            this.assignWireOffset(classDesc);
            classDesc.writeClassInfo(this);
            this.write(120);
            this.writeObject(classDesc.getSuperclass());
            this.assignWireOffset(clazz);
            return;
        }
        if (obj instanceof ClassDescriptor) {
            this.write(114);
            this.writeUTF(classDesc.getName());
            long value = classDesc.getSerialVersionUID();
            this.write((int)(value >>> 56) & 0xFF);
            this.write((int)(value >>> 48) & 0xFF);
            this.write((int)(value >>> 40) & 0xFF);
            this.write((int)(value >>> 32) & 0xFF);
            this.write((int)(value >>> 24) & 0xFF);
            this.write((int)(value >>> 16) & 0xFF);
            this.write((int)(value >>> 8) & 0xFF);
            this.write((int)(value >>> 0) & 0xFF);
            this.assignWireOffset(classDesc);
            this.write(classDesc.flags);
            tmpInt = classDesc.fields.length;
            this.write(tmpInt >>> 8 & 0xFF);
            this.write(tmpInt >>> 0 & 0xFF);
            for (int i = 0; i < classDesc.fields.length; ++i) {
                FieldDescriptor field = classDesc.fields[i];
                this.write(field.typeCode);
                this.writeUTF(field.name);
                if (field.type.isPrimitive()) continue;
                this.writeObject(field.typeString);
            }
            this.write(120);
            this.writeObject(classDesc.getSuperclass());
            return;
        }
        if (obj instanceof String) {
            this.write(116);
            String s = ((String)obj).intern();
            this.assignWireOffset(s);
            this.writeUTF(s);
            return;
        }
        if (clazz.isArray()) {
            this.write(117);
            this.writeObject(classDesc);
            this.assignWireOffset(obj);
            Class<?> type = clazz.getComponentType();
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    int[] array = (int[])obj;
                    tmpInt = array.length;
                    this.write(tmpInt >>> 24 & 0xFF);
                    this.write(tmpInt >>> 16 & 0xFF);
                    this.write(tmpInt >>> 8 & 0xFF);
                    this.write(tmpInt >>> 0 & 0xFF);
                    for (int i = 0; i < tmpInt; ++i) {
                        int value = array[i];
                        this.write(value >>> 24 & 0xFF);
                        this.write(value >>> 16 & 0xFF);
                        this.write(value >>> 8 & 0xFF);
                        this.write(value >>> 0 & 0xFF);
                    }
                    return;
                }
                if (type == Byte.TYPE) {
                    byte[] array = (byte[])obj;
                    tmpInt = array.length;
                    this.write(tmpInt >>> 24 & 0xFF);
                    this.write(tmpInt >>> 16 & 0xFF);
                    this.write(tmpInt >>> 8 & 0xFF);
                    this.write(tmpInt >>> 0 & 0xFF);
                    this.write(array, 0, tmpInt);
                    return;
                }
                if (type == Long.TYPE) {
                    long[] array = (long[])obj;
                    tmpInt = array.length;
                    this.write(tmpInt >>> 24 & 0xFF);
                    this.write(tmpInt >>> 16 & 0xFF);
                    this.write(tmpInt >>> 8 & 0xFF);
                    this.write(tmpInt >>> 0 & 0xFF);
                    for (int i = 0; i < tmpInt; ++i) {
                        long value = array[i];
                        this.write((int)(value >>> 56) & 0xFF);
                        this.write((int)(value >>> 48) & 0xFF);
                        this.write((int)(value >>> 40) & 0xFF);
                        this.write((int)(value >>> 32) & 0xFF);
                        this.write((int)(value >>> 24) & 0xFF);
                        this.write((int)(value >>> 16) & 0xFF);
                        this.write((int)(value >>> 8) & 0xFF);
                        this.write((int)(value >>> 0) & 0xFF);
                    }
                    return;
                }
                if (type == Float.TYPE) {
                    float[] array = (float[])obj;
                    tmpInt = array.length;
                    this.write(tmpInt >>> 24 & 0xFF);
                    this.write(tmpInt >>> 16 & 0xFF);
                    this.write(tmpInt >>> 8 & 0xFF);
                    this.write(tmpInt >>> 0 & 0xFF);
                    for (int i = 0; i < tmpInt; ++i) {
                        int value = Float.floatToIntBits(array[i]);
                        this.write(value >>> 24 & 0xFF);
                        this.write(value >>> 16 & 0xFF);
                        this.write(value >>> 8 & 0xFF);
                        this.write(value >>> 0 & 0xFF);
                    }
                    return;
                }
                if (type == Double.TYPE) {
                    double[] array = (double[])obj;
                    tmpInt = array.length;
                    this.write(tmpInt >>> 24 & 0xFF);
                    this.write(tmpInt >>> 16 & 0xFF);
                    this.write(tmpInt >>> 8 & 0xFF);
                    this.write(tmpInt >>> 0 & 0xFF);
                    for (int i = 0; i < tmpInt; ++i) {
                        long value = Double.doubleToLongBits(array[i]);
                        this.write((int)(value >>> 56) & 0xFF);
                        this.write((int)(value >>> 48) & 0xFF);
                        this.write((int)(value >>> 40) & 0xFF);
                        this.write((int)(value >>> 32) & 0xFF);
                        this.write((int)(value >>> 24) & 0xFF);
                        this.write((int)(value >>> 16) & 0xFF);
                        this.write((int)(value >>> 8) & 0xFF);
                        this.write((int)(value >>> 0) & 0xFF);
                    }
                    return;
                }
                if (type == Short.TYPE) {
                    short[] array = (short[])obj;
                    tmpInt = array.length;
                    this.write(tmpInt >>> 24 & 0xFF);
                    this.write(tmpInt >>> 16 & 0xFF);
                    this.write(tmpInt >>> 8 & 0xFF);
                    this.write(tmpInt >>> 0 & 0xFF);
                    for (int i = 0; i < tmpInt; ++i) {
                        short value = array[i];
                        this.write(value >>> 8 & 0xFF);
                        this.write(value >>> 0 & 0xFF);
                    }
                    return;
                }
                if (type == Character.TYPE) {
                    char[] array = (char[])obj;
                    tmpInt = array.length;
                    this.write(tmpInt >>> 24 & 0xFF);
                    this.write(tmpInt >>> 16 & 0xFF);
                    this.write(tmpInt >>> 8 & 0xFF);
                    this.write(tmpInt >>> 0 & 0xFF);
                    for (int i = 0; i < tmpInt; ++i) {
                        char value = array[i];
                        this.write(value >>> 8 & 0xFF);
                        this.write(value >>> 0 & 0xFF);
                    }
                    return;
                }
                if (type == Boolean.TYPE) {
                    boolean[] array = (boolean[])obj;
                    tmpInt = array.length;
                    this.write(tmpInt >>> 24 & 0xFF);
                    this.write(tmpInt >>> 16 & 0xFF);
                    this.write(tmpInt >>> 8 & 0xFF);
                    this.write(tmpInt >>> 0 & 0xFF);
                    for (int i = 0; i < tmpInt; ++i) {
                        this.write(array[i] ? 1 : 0);
                    }
                    return;
                }
                throw new InvalidClassException(clazz.getName());
            }
            Object[] array = (Object[])obj;
            int length = array.length;
            this.write(length >>> 24 & 0xFF);
            this.write(length >>> 16 & 0xFF);
            this.write(length >>> 8 & 0xFF);
            this.write(length >>> 0 & 0xFF);
            for (int i = 0; i < length; ++i) {
                this.writeObject(array[i]);
            }
            return;
        }
        this.write(115);
        this.writeObject(classDesc);
        this.assignWireOffset(obj);
        if (classDesc.isExternalizable()) {
            this.writeExternal((Externalizable)obj);
            return;
        }
        int stackMark = this.classDescStack.size();
        while ((superClassDesc = classDesc.getSuperclass()) != null) {
            this.classDescStack.push(classDesc);
            classDesc = superClassDesc;
        }
        do {
            FieldDescriptor[] fields;
            if (classDesc.hasWriteObjectMethod() || (fields = classDesc.getFields()).length <= 0) continue;
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i].getField();
                if (field == null) {
                    throw new InvalidClassException(clazz.getName(), "Nonexistent field " + fields[i].getName());
                }
                try {
                    switch (fields[i].getTypeCode()) {
                        case 'B': {
                            this.write(field.getByte(obj));
                            break;
                        }
                        case 'C': {
                            char charvalue = field.getChar(obj);
                            this.write(charvalue >>> 8 & 0xFF);
                            this.write(charvalue >>> 0 & 0xFF);
                            break;
                        }
                        case 'I': {
                            int intvalue = field.getInt(obj);
                            this.write(intvalue >>> 24 & 0xFF);
                            this.write(intvalue >>> 16 & 0xFF);
                            this.write(intvalue >>> 8 & 0xFF);
                            this.write(intvalue >>> 0 & 0xFF);
                            break;
                        }
                        case 'Z': {
                            this.write(field.getBoolean(obj) ? 1 : 0);
                            break;
                        }
                        case 'J': {
                            long longvalue = field.getLong(obj);
                            this.write((int)(longvalue >>> 56) & 0xFF);
                            this.write((int)(longvalue >>> 48) & 0xFF);
                            this.write((int)(longvalue >>> 40) & 0xFF);
                            this.write((int)(longvalue >>> 32) & 0xFF);
                            this.write((int)(longvalue >>> 24) & 0xFF);
                            this.write((int)(longvalue >>> 16) & 0xFF);
                            this.write((int)(longvalue >>> 8) & 0xFF);
                            this.write((int)(longvalue >>> 0) & 0xFF);
                            break;
                        }
                        case 'F': {
                            int floatvalue = Float.floatToIntBits(field.getFloat(obj));
                            this.write(floatvalue >>> 24 & 0xFF);
                            this.write(floatvalue >>> 16 & 0xFF);
                            this.write(floatvalue >>> 8 & 0xFF);
                            this.write(floatvalue >>> 0 & 0xFF);
                            break;
                        }
                        case 'D': {
                            long doublevalue = Double.doubleToLongBits(field.getDouble(obj));
                            this.write((int)(doublevalue >>> 56) & 0xFF);
                            this.write((int)(doublevalue >>> 48) & 0xFF);
                            this.write((int)(doublevalue >>> 40) & 0xFF);
                            this.write((int)(doublevalue >>> 32) & 0xFF);
                            this.write((int)(doublevalue >>> 24) & 0xFF);
                            this.write((int)(doublevalue >>> 16) & 0xFF);
                            this.write((int)(doublevalue >>> 8) & 0xFF);
                            this.write((int)(doublevalue >>> 0) & 0xFF);
                            break;
                        }
                        case 'S': {
                            short shortvalue = field.getShort(obj);
                            this.write(shortvalue >>> 8 & 0xFF);
                            this.write(shortvalue >>> 0 & 0xFF);
                            break;
                        }
                        case 'L': 
                        case '[': {
                            this.writeObject(field.get(obj));
                            break;
                        }
                        default: {
                            throw new InvalidClassException(clazz.getName());
                        }
                    }
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new InvalidClassException(clazz.getName(), e.getMessage());
                }
            }
        } while (this.classDescStack.size() > stackMark && (classDesc = (ClassDescriptor)this.classDescStack.pop()) != null);
    }

    public void writeString(String s) throws IOException {
        this.writeObject(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExternal(Externalizable ext) throws IOException {
        ext.writeExternal(this);
    }

    public void writeException(Throwable th) throws IOException {
    }

    public void writeReset() throws IOException {
    }

    public void write(int b) {
        try {
            this.buf[this.count++] = (byte)b;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, this.count)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count - 1);
            this.buf = newbuf;
        }
    }

    public synchronized void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void flush() throws IOException {
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeBytes(String s) throws IOException {
        int tmpLen = s.length();
        for (int i = 0; i < tmpLen; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    public final void writeChars(String s) throws IOException {
        int tmpLen = s.length();
        for (int i = 0; i < tmpLen; ++i) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }
    }

    public final void writeUTF(String str) throws IOException {
        int len = str.length();
        if (this.utfCharBuf.length < len) {
            this.utfCharBuf = new char[len];
        }
        str.getChars(0, len, this.utfCharBuf, 0);
        int mark = this.count;
        this.write(0);
        this.write(0);
        for (int i = 0; i < len; ++i) {
            char c = this.utfCharBuf[i];
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c >> 0 & 0x3F);
        }
        len = this.count - mark - 2;
        this.buf[mark] = (byte)(len >>> 8 & 0xFF);
        this.buf[mark + 1] = (byte)(len >>> 0 & 0xFF);
    }

    private void hashInsert(Object obj, int offset) {
        int hash = System.identityHashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % this.wireHash2Handle.length;
        this.wireNextHandle[offset] = this.wireHash2Handle[index];
        this.wireHash2Handle[index] = offset;
    }

    private int findWireOffset(Object obj) {
        int hash = System.identityHashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % this.wireHash2Handle.length;
        int handle = this.wireHash2Handle[index];
        while (handle >= 0) {
            if (this.wireHandle2Object.get(handle) == obj) {
                return handle;
            }
            handle = this.wireNextHandle[handle];
        }
        return -1;
    }

    private void assignWireOffset(Object obj) throws IOException {
        if (this.nextWireOffset == this.wireNextHandle.length) {
            int[] oldnexthandles = this.wireNextHandle;
            this.wireNextHandle = new int[this.nextWireOffset * 2];
            System.arraycopy(oldnexthandles, 0, this.wireNextHandle, 0, this.nextWireOffset);
        }
        if (this.nextWireOffset >= this.wireHashCapacity) {
            this.growWireHash2Handle();
        }
        this.wireHandle2Object.add(obj);
        this.hashInsert(obj, this.nextWireOffset);
        ++this.nextWireOffset;
    }

    private void growWireHash2Handle() {
        int i;
        ++this.wireHashSizePower;
        this.wireHash2Handle = new int[(1 << this.wireHashSizePower) - 1];
        Arrays.fill(this.wireHash2Handle, -1);
        for (i = 0; i < this.nextWireOffset; ++i) {
            this.wireNextHandle[i] = 0;
        }
        for (i = 0; i < this.wireHandle2Object.size(); ++i) {
            this.hashInsert(this.wireHandle2Object.get(i), i);
        }
        this.wireHashCapacity = (1 << this.wireHashSizePower) * this.wireHashLoadFactor;
    }

    private void resetStream() throws IOException {
        if (this.wireHandle2Object == null) {
            this.wireHandle2Object = new ArrayList();
            this.wireNextHandle = new int[4];
            this.wireHash2Handle = new int[(1 << this.wireHashSizePower) - 1];
        } else {
            this.wireHandle2Object.clear();
            for (int i = 0; i < this.nextWireOffset; ++i) {
                this.wireNextHandle[i] = 0;
            }
        }
        this.nextWireOffset = 0;
        Arrays.fill(this.wireHash2Handle, -1);
        if (this.classDescStack == null) {
            this.classDescStack = new ArrayStack();
        } else {
            this.classDescStack.setSize(0);
        }
    }
}

