/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateless;

import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;
import org.openejb.test.object.OperationsPolicy;
import org.openejb.test.stateless.BasicStatelessHome;
import org.openejb.test.stateless.BasicStatelessTestClient;

public class StatelessAllowedOperationsTests
extends BasicStatelessTestClient {
    public StatelessAllowedOperationsTests() {
        super("AllowedOperations.");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessHome");
        this.ejbHome = (BasicStatelessHome)PortableRemoteObject.narrow((Object)obj, (Class)BasicStatelessHome.class);
        this.ejbObject = this.ejbHome.create();
        this.ejbHandle = this.ejbObject.getHandle();
        this.ejbObject.businessMethod("activate me please");
    }

    private void setUp_ejbActivate_Passivate() throws Exception {
        EJBObject[] ejbObjects = new EJBObject[10];
        for (int i = 0; i < ejbObjects.length; ++i) {
            ejbObjects[i] = this.ejbHome.create();
        }
        this.ejbObject.businessMethod("activate me please");
    }

    protected void tearDown() throws Exception {
        try {
            this.ejbObject.remove();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            super.tearDown();
        }
    }

    public void test01_setSessionContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("setSessionContext");
            StatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_ejbCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbCreate");
            StatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void TODO_test03_ejbRemove() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbRemove");
            StatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void TODO_test04_businessMethod() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(2);
            policy.allow(4);
            policy.allow(6);
            policy.allow(8);
            policy.allow(9);
            policy.allow(10);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("businessMethod");
            StatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

