/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateless;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.openejb.test.TestFailureException;
import org.openejb.test.entity.bmp.BasicBmpHome;
import org.openejb.test.entity.bmp.BasicBmpObject;
import org.openejb.test.stateful.BasicStatefulHome;
import org.openejb.test.stateful.BasicStatefulObject;
import org.openejb.test.stateless.BasicStatelessHome;
import org.openejb.test.stateless.BasicStatelessObject;

public class EncStatelessBean
implements SessionBean {
    private String name;
    private SessionContext ejbContext;

    public void lookupEntityBean() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                BasicBmpHome home = (BasicBmpHome)PortableRemoteObject.narrow((Object)ctx.lookup("java:comp/env/stateless/beanReferences/bmp_entity"), (Class)BasicBmpHome.class);
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicBmpObject object = home.create("Enc Bean");
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBean() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                BasicStatefulHome home = (BasicStatefulHome)PortableRemoteObject.narrow((Object)ctx.lookup("java:comp/env/stateless/beanReferences/stateful"), (Class)BasicStatefulHome.class);
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicStatefulObject object = home.create("Enc Bean");
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatelessBean() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                BasicStatelessHome home = (BasicStatelessHome)PortableRemoteObject.narrow((Object)ctx.lookup("java:comp/env/stateless/beanReferences/stateless"), (Class)BasicStatelessHome.class);
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicStatelessObject object = home.create();
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStringEntry() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                String expected = new String("1");
                String actual = (String)ctx.lookup("java:comp/env/stateless/references/String");
                Assert.assertNotNull((String)"The String looked up is null", (Object)actual);
                Assert.assertEquals((String)expected, (String)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupDoubleEntry() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                Double expected = new Double(1.0);
                Double actual = (Double)ctx.lookup("java:comp/env/stateless/references/Double");
                Assert.assertNotNull((String)"The Double looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupLongEntry() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                Long expected = new Long(1L);
                Long actual = (Long)ctx.lookup("java:comp/env/stateless/references/Long");
                Assert.assertNotNull((String)"The Long looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupFloatEntry() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                Float expected = new Float(1.0f);
                Float actual = (Float)ctx.lookup("java:comp/env/stateless/references/Float");
                Assert.assertNotNull((String)"The Float looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupIntegerEntry() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                Integer expected = new Integer(1);
                Integer actual = (Integer)ctx.lookup("java:comp/env/stateless/references/Integer");
                Assert.assertNotNull((String)"The Integer looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupShortEntry() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                Short expected = new Short(1);
                Short actual = (Short)ctx.lookup("java:comp/env/stateless/references/Short");
                Assert.assertNotNull((String)"The Short looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupBooleanEntry() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                Boolean expected = new Boolean(true);
                Boolean actual = (Boolean)ctx.lookup("java:comp/env/stateless/references/Boolean");
                Assert.assertNotNull((String)"The Boolean looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupByteEntry() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                Byte expected = new Byte(1);
                Byte actual = (Byte)ctx.lookup("java:comp/env/stateless/references/Byte");
                Assert.assertNotNull((String)"The Byte looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupResource() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.ejbContext = ctx;
    }

    public void ejbCreate() throws CreateException {
        this.name = "nameless automaton";
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }
}

