/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateless;

import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.rmi.PortableRemoteObject;
import org.openejb.test.stateless.BasicStatelessHome;
import org.openejb.test.stateless.BasicStatelessTestClient;

public class StatelessEjbObjectTests
extends BasicStatelessTestClient {
    public StatelessEjbObjectTests() {
        super("EJBObject.");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessHome");
        this.ejbHome = (BasicStatelessHome)PortableRemoteObject.narrow((Object)obj, (Class)BasicStatelessHome.class);
        this.ejbObject = this.ejbHome.create();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test01_getHandle() {
        try {
            this.ejbHandle = this.ejbObject.getHandle();
            StatelessEjbObjectTests.assertNotNull((String)"The Handle is null", (Object)this.ejbHandle);
        }
        catch (Exception e) {
            StatelessEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_isIdentical() {
        try {
            StatelessEjbObjectTests.assertTrue((String)"The EJBObjects are not identical", (boolean)this.ejbObject.isIdentical(this.ejbObject));
        }
        catch (Exception e) {
            StatelessEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_getEjbHome() {
        try {
            EJBHome home = this.ejbObject.getEJBHome();
            StatelessEjbObjectTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            StatelessEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_getPrimaryKey() {
        try {
            Object key = this.ejbObject.getPrimaryKey();
        }
        catch (RemoteException e) {
            StatelessEjbObjectTests.assertTrue((boolean)true);
            return;
        }
        catch (Exception e) {
            StatelessEjbObjectTests.fail((String)("A RuntimeException should have been thrown.  Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessEjbObjectTests.fail((String)"A RuntimeException should have been thrown.");
    }

    public void test05_remove() {
        try {
            this.ejbObject.remove();
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                StatelessEjbObjectTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception e) {
                StatelessEjbObjectTests.assertTrue((boolean)true);
                return;
            }
        }
        catch (Exception e) {
            StatelessEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

