/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateless;

import javax.rmi.PortableRemoteObject;
import org.openejb.test.entity.bmp.EncBmpHome;
import org.openejb.test.entity.bmp.EncBmpObject;
import org.openejb.test.entity.cmp.EncCmpHome;
import org.openejb.test.entity.cmp.EncCmpObject;
import org.openejb.test.stateful.EncStatefulHome;
import org.openejb.test.stateful.EncStatefulObject;
import org.openejb.test.stateless.BasicStatelessHome;
import org.openejb.test.stateless.BasicStatelessTestClient;
import org.openejb.test.stateless.EncStatelessHome;
import org.openejb.test.stateless.EncStatelessObject;

public class MiscEjbTests
extends BasicStatelessTestClient {
    public MiscEjbTests() {
        super("EJBObject.");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessHome");
        this.ejbHome = (BasicStatelessHome)PortableRemoteObject.narrow((Object)obj, (Class)BasicStatelessHome.class);
        this.ejbObject = this.ejbHome.create();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test01_isIdentical_stateless() {
        try {
            String jndiName = "client/tests/stateless/EncBean";
            EncStatelessHome ejbHome2 = null;
            EncStatelessObject ejbObject2 = null;
            Object obj = this.initialContext.lookup(jndiName);
            ejbHome2 = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, (Class)EncStatelessHome.class);
            ejbObject2 = ejbHome2.create();
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical(ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_isIdentical_stateful() {
        try {
            String jndiName = "client/tests/stateful/EncBean";
            EncStatefulHome ejbHome2 = null;
            EncStatefulObject ejbObject2 = null;
            Object obj = this.initialContext.lookup(jndiName);
            ejbHome2 = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, (Class)EncStatefulHome.class);
            ejbObject2 = ejbHome2.create("isIdentical test");
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical(ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_isIdentical_bmp() {
        try {
            String jndiName = "client/tests/entity/bmp/EncBean";
            EncBmpHome ejbHome2 = null;
            EncBmpObject ejbObject2 = null;
            Object obj = this.initialContext.lookup(jndiName);
            ejbHome2 = (EncBmpHome)PortableRemoteObject.narrow((Object)obj, (Class)EncBmpHome.class);
            ejbObject2 = ejbHome2.create("isIdentical test");
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical(ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void _test04_isIdentical_cmp() {
        try {
            String jndiName = "client/tests/entity/cmp/EncBean";
            EncCmpHome ejbHome2 = null;
            EncCmpObject ejbObject2 = null;
            Object obj = this.initialContext.lookup(jndiName);
            ejbHome2 = (EncCmpHome)PortableRemoteObject.narrow((Object)obj, (Class)EncCmpHome.class);
            ejbObject2 = ejbHome2.create("isIdentical test");
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical(ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

