/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.openejb.test.TestServer;
import org.openejb.util.Launcher;

public class RemoteTestServer
implements TestServer {
    private boolean serverHasAlreadyBeenStarted = true;
    private Properties properties;

    public void init(Properties props) {
        this.properties = props;
        props.put("test.server.class", "org.openejb.test.RemoteTestServer");
        props.put("java.naming.factory.initial", "org.openejb.client.RemoteInitialContextFactory");
        props.put("java.naming.provider.url", "127.0.0.1:4201");
        props.put("java.naming.security.principal", "testuser");
        props.put("java.naming.security.credentials", "testpassword");
    }

    public void destroy() {
    }

    public void start() {
        if (!this.connect()) {
            try {
                System.out.println("[] START SERVER");
                this.serverHasAlreadyBeenStarted = false;
                Launcher.main((String[])new String[]{"-nowait", "org.openejb.server.Main"});
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot start the server.");
            }
            this.connect(10);
        }
    }

    private void oldStart() throws IOException, FileNotFoundException {
        String s = File.separator;
        String java = System.getProperty("java.home") + s + "bin" + s + "java";
        String classpath = System.getProperty("java.class.path");
        String openejbHome = System.getProperty("openejb.home");
        String[] cmd = new String[]{java, "-classpath", classpath, "-Dopenejb.home=" + openejbHome, "org.openejb.server.Main"};
        for (int i = 0; i < cmd.length; ++i) {
        }
        Process remoteServerProcess = Runtime.getRuntime().exec(cmd);
        final InputStream is = remoteServerProcess.getInputStream();
        final FileOutputStream out = new FileOutputStream("logs/testsuite.out");
        Thread serverOut = new Thread(new Runnable(){

            public void run() {
                try {
                    int i = is.read();
                    out.write(i);
                    while (i != -1) {
                        i = is.read();
                        out.write(i);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        serverOut.setDaemon(true);
        serverOut.start();
        final InputStream is2 = remoteServerProcess.getErrorStream();
        Thread serverErr = new Thread(new Runnable(){

            public void run() {
                try {
                    int i = is2.read();
                    out.write(i);
                    while (i != -1) {
                        i = is2.read();
                        out.write(i);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        serverErr.setDaemon(true);
        serverErr.start();
    }

    public void stop() {
        if (!this.serverHasAlreadyBeenStarted) {
            try {
                System.out.println("[] STOP SERVER");
                Socket socket = new Socket("localhost", 4201);
                OutputStream out = socket.getOutputStream();
                out.write("Stop".getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Properties getContextEnvironment() {
        return (Properties)this.properties.clone();
    }

    private boolean connect() {
        return this.connect(1);
    }

    private boolean connect(int tries) {
        try {
            Socket socket = new Socket("localhost", 4201);
            OutputStream out = socket.getOutputStream();
        }
        catch (Exception e) {
            if (tries < 2) {
                return false;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
            return this.connect(--tries);
        }
        return true;
    }

    static {
        System.setProperty("noBanner", "true");
    }
}

