/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.entity.bmp;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import org.openejb.test.ApplicationException;
import org.openejb.test.entity.bmp.BasicBmpHome;
import org.openejb.test.entity.bmp.BasicBmpTestClient;

public class BmpRemoteIntfcTests
extends BasicBmpTestClient {
    public BmpRemoteIntfcTests() {
        super("RemoteIntfc.");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/bmp/BasicBmpHome");
        this.ejbHome = (BasicBmpHome)PortableRemoteObject.narrow((Object)obj, (Class)BasicBmpHome.class);
        this.ejbObject = this.ejbHome.create("Forth Bean");
    }

    public void test01_businessMethod() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            BmpRemoteIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Exception e) {
            BmpRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.ejbObject.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            BmpRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        BmpRemoteIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            BmpRemoteIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Throwable e) {
            BmpRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_throwSystemException() {
        try {
            this.ejbObject.throwSystemException_NullPointer();
        }
        catch (RemoteException e) {
            Throwable n = e.detail;
            BmpRemoteIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            BmpRemoteIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            BmpRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        BmpRemoteIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void BUG_test05_invokeAfterSystemException() {
        try {
            this.ejbObject.businessMethod("This refernce is invalid");
            BmpRemoteIntfcTests.fail((String)"A java.rmi.NoSuchObjectException should have been thrown.");
        }
        catch (NoSuchObjectException e) {
        }
        catch (Throwable e) {
            BmpRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

