/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateless;

import javax.rmi.PortableRemoteObject;
import org.openejb.test.object.OperationsPolicy;
import org.openejb.test.stateless.BasicStatelessHome;
import org.openejb.test.stateless.BasicStatelessTestClient;

public class BMTStatelessAllowedOperationsTests
extends BasicStatelessTestClient {
    public BMTStatelessAllowedOperationsTests() {
        super("BMTAllowedOperations.");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BeanManagedBasicStatelessHome");
        this.ejbHome = (BasicStatelessHome)PortableRemoteObject.narrow((Object)obj, (Class)BasicStatelessHome.class);
        this.ejbObject = this.ejbHome.create();
        this.ejbHandle = this.ejbObject.getHandle();
        this.ejbObject.businessMethod("let's go!");
    }

    protected void tearDown() throws Exception {
        try {
            this.ejbObject.remove();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            super.tearDown();
        }
    }

    public void test01_setSessionContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("setSessionContext");
            BMTStatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_ejbCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(5);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbCreate");
            BMTStatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void TODO_test03_ejbRemove() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(5);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbRemove");
            BMTStatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_businessMethod() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(5);
            policy.allow(8);
            policy.allow(9);
            policy.allow(10);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("businessMethod");
            BMTStatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

