/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.beans;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class EmployeeBean
implements EntityBean {
    int id;
    String lastName;
    String firstName;
    EntityContext ejbContext;

    public int ejbHomeSum(int one, int two) {
        return one + two;
    }

    public Integer ejbFindByPrimaryKey(Integer primaryKey) throws FinderException {
        boolean found = false;
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/orders");
            Connection con = ds.getConnection();
            PreparedStatement stmt = con.prepareStatement("select * from Employees where EmployeeID = ?");
            stmt.setInt(1, primaryKey);
            ResultSet rs = stmt.executeQuery();
            found = rs.next();
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FinderException("FindByPrimaryKey failed");
        }
        if (found) {
            return primaryKey;
        }
        throw new ObjectNotFoundException();
    }

    public Collection ejbFindAll() throws FinderException {
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/orders");
            Connection con = ds.getConnection();
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("select EmployeeID from Employees");
            Vector<Integer> keys = new Vector<Integer>();
            while (rs.next()) {
                keys.addElement(new Integer(rs.getInt("EmployeeID")));
            }
            con.close();
            return keys;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FinderException("FindAll failed");
        }
    }

    public Integer ejbCreate(String fname, String lname) throws CreateException {
        try {
            this.lastName = lname;
            this.firstName = fname;
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/orders");
            Connection con = ds.getConnection();
            PreparedStatement stmt = con.prepareStatement("insert into Employees (FirstName, LastName) values (?,?)");
            stmt.setString(1, this.firstName);
            stmt.setString(2, this.lastName);
            stmt.executeUpdate();
            stmt = con.prepareStatement("select EmployeeID from Employees where FirstName = ? AND LastName = ?");
            stmt.setString(1, this.firstName);
            stmt.setString(2, this.lastName);
            ResultSet set = stmt.executeQuery();
            while (set.next()) {
                this.id = set.getInt("EmployeeID");
            }
            con.close();
            return new Integer(this.id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CreateException("can't create");
        }
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setLastName(String lname) {
        this.lastName = lname;
    }

    public void setFirstName(String fname) {
        this.firstName = fname;
    }

    public void ejbLoad() {
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/orders");
            Connection con = ds.getConnection();
            PreparedStatement stmt = con.prepareStatement("select * from Employees where EmployeeID = ?");
            Integer primaryKey = (Integer)this.ejbContext.getPrimaryKey();
            stmt.setInt(1, primaryKey);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                this.lastName = rs.getString("LastName");
                this.firstName = rs.getString("FirstName");
            }
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ejbStore() {
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/orders");
            Connection con = ds.getConnection();
            PreparedStatement stmt = con.prepareStatement("update Employees set FirstName = ?, LastName = ? where EmployeeID = ?");
            stmt.setString(1, this.firstName);
            stmt.setString(2, this.lastName);
            stmt.setInt(3, this.id);
            stmt.execute();
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/orders");
            Connection con = ds.getConnection();
            PreparedStatement stmt = con.prepareStatement("delete from Employees where EmployeeID = ?");
            Integer primaryKey = (Integer)this.ejbContext.getPrimaryKey();
            stmt.setInt(1, primaryKey);
            stmt.executeUpdate();
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEntityContext(EntityContext cntx) {
        this.ejbContext = cntx;
    }

    public void unsetEntityContext() {
    }
}

