/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateful;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import org.openejb.test.ApplicationException;
import org.openejb.test.stateful.BasicStatefulHome;
import org.openejb.test.stateful.BasicStatefulTestClient;

public class StatefulRemoteIntfcTests
extends BasicStatefulTestClient {
    public StatefulRemoteIntfcTests() {
        super("RemoteIntfc.");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateful/BasicStatefulHome");
        this.ejbHome = (BasicStatefulHome)PortableRemoteObject.narrow((Object)obj, (Class)BasicStatefulHome.class);
        this.ejbObject = this.ejbHome.create("Third Bean");
    }

    public void test01_businessMethod() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            StatefulRemoteIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Throwable e) {
            StatefulRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.ejbObject.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            StatefulRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatefulRemoteIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            StatefulRemoteIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Throwable e) {
            StatefulRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_throwSystemException() {
        try {
            this.ejbObject.throwSystemException_NullPointer();
        }
        catch (RemoteException e) {
            Throwable n = e.detail;
            StatefulRemoteIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            StatefulRemoteIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            StatefulRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatefulRemoteIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void test05_invokeAfterSystemException() {
        try {
            this.ejbObject.businessMethod("This refernce is invalid");
            StatefulRemoteIntfcTests.fail((String)"A java.rmi.NoSuchObjectException should have been thrown.");
        }
        catch (NoSuchObjectException e) {
        }
        catch (Throwable e) {
            StatefulRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

