/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.entity.bmp;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.openejb.test.ApplicationException;
import org.openejb.test.object.OperationsPolicy;

public class BasicBmpBean
implements EntityBean {
    public int primaryKey;
    public String firstName;
    public String lastName;
    public EntityContext ejbContext;
    public Hashtable allowedOperationsTable = new Hashtable();

    public int ejbHomeSum(int x, int y) {
        this.testAllowedOperations("ejbHome");
        return x + y;
    }

    public Collection ejbFindEmptyCollection() throws FinderException, RemoteException {
        return new Vector();
    }

    public Enumeration ejbFindEmptyEnumeration() throws FinderException {
        return new Vector().elements();
    }

    public Integer ejbFindByPrimaryKey(Integer primaryKey) throws FinderException {
        boolean found = false;
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            Connection con = ds.getConnection();
            PreparedStatement stmt = con.prepareStatement("select * from entity where id = ?");
            stmt.setInt(1, primaryKey);
            found = stmt.executeQuery().next();
            con.close();
        }
        catch (Exception e) {
            throw new FinderException("FindByPrimaryKey failed");
        }
        if (found) {
            return primaryKey;
        }
        throw new ObjectNotFoundException();
    }

    public Collection ejbFindByLastName(String lastName) throws FinderException {
        Vector<Integer> keys = new Vector<Integer>();
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            Connection con = ds.getConnection();
            PreparedStatement stmt = con.prepareStatement("SELECT id FROM entity WHERE last_name = ?");
            stmt.setString(1, lastName);
            ResultSet set = stmt.executeQuery();
            while (set.next()) {
                keys.add(new Integer(set.getInt("id")));
            }
            con.close();
        }
        catch (Exception e) {
            throw new FinderException("FindByPrimaryKey failed");
        }
        if (keys.size() > 0) {
            return keys;
        }
        throw new ObjectNotFoundException();
    }

    public Integer ejbCreate(String name) throws CreateException {
        try {
            StringTokenizer st = new StringTokenizer(name, " ");
            this.firstName = st.nextToken();
            this.lastName = st.nextToken();
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            Connection con = ds.getConnection();
            PreparedStatement stmt = con.prepareStatement("insert into entity (first_name, last_name) values (?,?)");
            stmt.setString(1, this.firstName);
            stmt.setString(2, this.lastName);
            stmt.executeUpdate();
            stmt = con.prepareStatement("select id from entity where first_name = ? AND last_name = ?");
            stmt.setString(1, this.firstName);
            stmt.setString(2, this.lastName);
            ResultSet set = stmt.executeQuery();
            while (set.next()) {
                this.primaryKey = set.getInt("id");
            }
            con.close();
            return new Integer(this.primaryKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CreateException("can't create: " + e.getClass().getName() + " " + e.getMessage());
        }
    }

    public void ejbPostCreate(String name) throws CreateException {
    }

    public String businessMethod(String text) {
        this.testAllowedOperations("businessMethod");
        StringBuffer b = new StringBuffer(text);
        return b.reverse().toString();
    }

    public void throwApplicationException() throws ApplicationException {
        throw new ApplicationException("Testing ability to throw Application Exceptions");
    }

    public void throwSystemException_NullPointer() {
        throw new NullPointerException("Testing ability to throw System Exceptions");
    }

    public Properties getPermissionsReport() {
        return null;
    }

    public OperationsPolicy getAllowedOperationsReport(String methodName) {
        return (OperationsPolicy)this.allowedOperationsTable.get(methodName);
    }

    public void ejbLoad() throws EJBException, RemoteException {
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            Connection con = ds.getConnection();
            PreparedStatement stmt = con.prepareStatement("select * from entity where id = ?");
            Integer primaryKey = (Integer)this.ejbContext.getPrimaryKey();
            stmt.setInt(1, primaryKey);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                this.lastName = rs.getString("last_name");
                this.firstName = rs.getString("first_name");
            }
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
        this.ejbContext = ctx;
        this.testAllowedOperations("setEntityContext");
    }

    public void unsetEntityContext() throws EJBException, RemoteException {
        this.testAllowedOperations("unsetEntityContext");
    }

    public void ejbStore() throws EJBException, RemoteException {
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            Connection con = ds.getConnection();
            PreparedStatement stmt = con.prepareStatement("update entity set first_name = ?, last_name = ? where id = ?");
            stmt.setString(1, this.firstName);
            stmt.setString(2, this.lastName);
            stmt.setInt(3, this.primaryKey);
            stmt.execute();
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ejbRemove() throws RemoveException, EJBException, RemoteException {
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            Connection con = ds.getConnection();
            PreparedStatement stmt = con.prepareStatement("delete from entity where id = ?");
            Integer primaryKey = (Integer)this.ejbContext.getPrimaryKey();
            stmt.setInt(1, primaryKey);
            stmt.executeUpdate();
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException(e);
        }
    }

    public void ejbActivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbActivate");
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbPassivate");
    }

    protected void testAllowedOperations(String methodName) {
        InitialContext jndiContext;
        OperationsPolicy policy = new OperationsPolicy();
        try {
            this.ejbContext.getEJBHome();
            policy.allow(0);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getCallerPrincipal();
            policy.allow(1);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.isCallerInRole("ROLE");
            policy.allow(2);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getRollbackOnly();
            policy.allow(3);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.setRollbackOnly();
            policy.allow(4);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getUserTransaction();
            policy.allow(5);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getEJBObject();
            policy.allow(6);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            String actual = (String)jndiContext.lookup("java:comp/env/stateless/references/JNDI_access_to_java_comp_env");
            policy.allow(8);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/stateless/references/Resource_manager_access");
            policy.allow(9);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            Object obj = jndiContext.lookup("java:comp/env/stateless/beanReferences/Enterprise_bean_access");
            policy.allow(10);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.allowedOperationsTable.put(methodName, policy);
    }
}

