/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateful;

import javax.rmi.PortableRemoteObject;
import org.openejb.test.object.OperationsPolicy;
import org.openejb.test.stateful.BasicStatefulHome;
import org.openejb.test.stateful.BasicStatefulTestClient;

public class StatefulAllowedOperationsTests
extends BasicStatefulTestClient {
    public StatefulAllowedOperationsTests() {
        super("AllowedOperations.");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateful/BasicStatefulHome");
        this.ejbHome = (BasicStatefulHome)PortableRemoteObject.narrow((Object)obj, (Class)BasicStatefulHome.class);
        this.ejbObject = this.ejbHome.create("Fourth Bean");
        this.ejbHandle = this.ejbObject.getHandle();
    }

    protected void tearDown() throws Exception {
        this.ejbObject.remove();
        super.tearDown();
    }

    public void test01_setSessionContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("setSessionContext");
            StatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_ejbCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(8);
            policy.allow(9);
            policy.allow(10);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbCreate");
            StatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_ejbRemove() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(8);
            policy.allow(9);
            policy.allow(10);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbRemove");
            StatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_ejbActivate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(8);
            policy.allow(9);
            policy.allow(10);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbActivate");
            StatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_ejbPassivate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(8);
            policy.allow(9);
            policy.allow(10);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbPassivate");
            StatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_businessMethod() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(2);
            policy.allow(4);
            policy.allow(6);
            policy.allow(8);
            policy.allow(9);
            policy.allow(10);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("businessMethod");
            StatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test07_afterBegin() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(2);
            policy.allow(4);
            policy.allow(6);
            policy.allow(8);
            policy.allow(9);
            policy.allow(10);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("afterBegin");
            StatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test08_beforeCompletion() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(2);
            policy.allow(4);
            policy.allow(6);
            policy.allow(8);
            policy.allow(9);
            policy.allow(10);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("beforeCompletion");
            StatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test09_afterCompletion() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(8);
            policy.allow(9);
            policy.allow(10);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("afterCompletion");
            StatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

