/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateful;

import javax.rmi.PortableRemoteObject;
import org.openejb.test.TestFailureException;
import org.openejb.test.TestManager;
import org.openejb.test.stateful.EncStatefulHome;
import org.openejb.test.stateful.EncStatefulObject;
import org.openejb.test.stateful.StatefulTestClient;

public class StatefulJndiEncTests
extends StatefulTestClient {
    protected EncStatefulHome ejbHome;
    protected EncStatefulObject ejbObject;

    public StatefulJndiEncTests() {
        super("JNDI_ENC.");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
        this.ejbHome = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, (Class)EncStatefulHome.class);
        this.ejbObject = this.ejbHome.create("Enc Bean");
        TestManager.getDatabase().createEntityTable();
    }

    protected void tearDown() throws Exception {
        try {
            TestManager.getDatabase().dropEntityTable();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            super.tearDown();
        }
    }

    public void test01_lookupStringEntry() {
        try {
            this.ejbObject.lookupStringEntry();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_lookupDoubleEntry() {
        try {
            this.ejbObject.lookupDoubleEntry();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_lookupLongEntry() {
        try {
            this.ejbObject.lookupLongEntry();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_lookupFloatEntry() {
        try {
            this.ejbObject.lookupFloatEntry();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_lookupIntegerEntry() {
        try {
            this.ejbObject.lookupIntegerEntry();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_lookupShortEntry() {
        try {
            this.ejbObject.lookupShortEntry();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test07_lookupBooleanEntry() {
        try {
            this.ejbObject.lookupBooleanEntry();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test08_lookupByteEntry() {
        try {
            this.ejbObject.lookupByteEntry();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test09_lookupEntityBean() {
        try {
            this.ejbObject.lookupEntityBean();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test10_lookupStatefulBean() {
        try {
            this.ejbObject.lookupStatefulBean();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test11_lookupStatelessBean() {
        try {
            this.ejbObject.lookupStatelessBean();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test12_lookupResource() {
        try {
            this.ejbObject.lookupResource();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulJndiEncTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

