/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateless;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import org.openejb.test.ApplicationException;
import org.openejb.test.stateless.BasicStatelessHome;
import org.openejb.test.stateless.BasicStatelessTestClient;

public class StatelessRemoteIntfcTests
extends BasicStatelessTestClient {
    public StatelessRemoteIntfcTests() {
        super("RemoteIntfc.");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessHome");
        this.ejbHome = (BasicStatelessHome)PortableRemoteObject.narrow((Object)obj, (Class)BasicStatelessHome.class);
        this.ejbObject = this.ejbHome.create();
    }

    public void test01_businessMethod() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            StatelessRemoteIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.ejbObject.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            StatelessRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessRemoteIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            StatelessRemoteIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Throwable e) {
            StatelessRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_throwSystemException() {
        try {
            this.ejbObject.throwSystemException_NullPointer();
        }
        catch (RemoteException e) {
            Throwable n = e.detail;
            StatelessRemoteIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            StatelessRemoteIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            StatelessRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessRemoteIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void TODO_test05_invokeAfterSystemException() {
        try {
            this.ejbObject.businessMethod("This refernce is invalid");
            StatelessRemoteIntfcTests.fail((String)"A java.rmi.NoSuchObjectException should have been thrown.");
        }
        catch (NoSuchObjectException e) {
        }
        catch (Throwable e) {
            StatelessRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

