/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.entity.bmp;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.openejb.test.ApplicationException;
import org.openejb.test.object.OperationsPolicy;

public class BasicBmpBean
implements EntityBean {
    public int primaryKey;
    public String firstName;
    public String lastName;
    public EntityContext ejbContext;
    public Hashtable allowedOperationsTable = new Hashtable();

    public int ejbHomeSum(int x, int y) {
        this.testAllowedOperations("ejbHome");
        return x + y;
    }

    public Collection ejbFindEmptyCollection() throws FinderException, RemoteException {
        return new Vector();
    }

    public Enumeration ejbFindEmptyEnumeration() throws FinderException {
        return new Vector().elements();
    }

    public Integer ejbFindByPrimaryKey(Integer primaryKey) throws FinderException {
        Connection con = null;
        PreparedStatement stmt = null;
        boolean found = false;
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            con = ds.getConnection();
            stmt = con.prepareStatement("select * from entity where id = ?");
            stmt.setInt(1, primaryKey);
            found = stmt.executeQuery().next();
        }
        catch (Exception e) {
            try {
                throw (FinderException)new FinderException("FindByPrimaryKey failed").initCause((Throwable)e);
            }
            catch (Throwable throwable) {
                BasicBmpBean.close(stmt);
                BasicBmpBean.close(con);
                throw throwable;
            }
        }
        BasicBmpBean.close(stmt);
        BasicBmpBean.close(con);
        if (found) {
            return primaryKey;
        }
        throw new ObjectNotFoundException();
    }

    public Collection ejbFindByLastName(String lastName) throws FinderException {
        Connection con = null;
        PreparedStatement stmt = null;
        Vector<Integer> keys = new Vector<Integer>();
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            con = ds.getConnection();
            stmt = con.prepareStatement("SELECT id FROM entity WHERE last_name = ?");
            stmt.setString(1, lastName);
            ResultSet set = stmt.executeQuery();
            while (set.next()) {
                keys.add(new Integer(set.getInt("id")));
            }
        }
        catch (Exception e) {
            try {
                throw (FinderException)new FinderException("FindByPrimaryKey failed").initCause((Throwable)e);
            }
            catch (Throwable throwable) {
                BasicBmpBean.close(stmt);
                BasicBmpBean.close(con);
                throw throwable;
            }
        }
        BasicBmpBean.close(stmt);
        BasicBmpBean.close(con);
        if (keys.size() > 0) {
            return keys;
        }
        throw new ObjectNotFoundException();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Integer ejbCreate(String name) throws CreateException {
        Integer n;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            StringTokenizer st = new StringTokenizer(name, " ");
            this.firstName = st.nextToken();
            this.lastName = st.nextToken();
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            con = ds.getConnection();
            stmt = con.prepareStatement("insert into entity (first_name, last_name) values (?,?)");
            stmt.setString(1, this.firstName);
            stmt.setString(2, this.lastName);
            if (stmt.executeUpdate() != 1) {
                throw new CreateException("Failed to insert exactally one row");
            }
            stmt.close();
            stmt = con.prepareStatement("select id from entity where first_name = ? AND last_name = ?");
            stmt.setString(1, this.firstName);
            stmt.setString(2, this.lastName);
            ResultSet set = stmt.executeQuery();
            if (!set.next()) {
                throw new CreateException("Failed to get primary key for new row");
            }
            this.primaryKey = set.getInt("id");
            n = new Integer(this.primaryKey);
        }
        catch (CreateException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw (CreateException)new CreateException().initCause((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                BasicBmpBean.close(stmt);
                BasicBmpBean.close(con);
                throw throwable;
            }
        }
        BasicBmpBean.close(stmt);
        BasicBmpBean.close(con);
        return n;
    }

    public void ejbPostCreate(String name) throws CreateException {
    }

    public String businessMethod(String text) {
        this.testAllowedOperations("businessMethod");
        StringBuffer b = new StringBuffer(text);
        return b.reverse().toString();
    }

    public void throwApplicationException() throws ApplicationException {
        throw new ApplicationException("Testing ability to throw Application Exceptions");
    }

    public void throwSystemException_NullPointer() {
        throw new NullPointerException("Testing ability to throw System Exceptions");
    }

    public Properties getPermissionsReport() {
        return null;
    }

    public OperationsPolicy getAllowedOperationsReport(String methodName) {
        return (OperationsPolicy)this.allowedOperationsTable.get(methodName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ejbLoad() throws EJBException, RemoteException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            con = ds.getConnection();
            stmt = con.prepareStatement("select * from entity where id = ?");
            Integer primaryKey = (Integer)this.ejbContext.getPrimaryKey();
            stmt.setInt(1, primaryKey);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new NoSuchEntityException();
            }
            this.lastName = rs.getString("last_name");
            this.firstName = rs.getString("first_name");
        }
        catch (NoSuchEntityException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new EJBException(e2);
                }
            }
            catch (Throwable throwable) {
                BasicBmpBean.close(stmt);
                BasicBmpBean.close(con);
                throw throwable;
            }
        }
        BasicBmpBean.close(stmt);
        BasicBmpBean.close(con);
    }

    public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
        this.ejbContext = ctx;
        this.testAllowedOperations("setEntityContext");
    }

    public void unsetEntityContext() throws EJBException, RemoteException {
        this.testAllowedOperations("unsetEntityContext");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ejbStore() throws EJBException, RemoteException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            con = ds.getConnection();
            stmt = con.prepareStatement("update entity set first_name = ?, last_name = ? where id = ?");
            stmt.setString(1, this.firstName);
            stmt.setString(2, this.lastName);
            stmt.setInt(3, this.primaryKey);
            if (stmt.execute()) {
                throw new NoSuchEntityException("Unable to update row: id=" + this.primaryKey);
            }
        }
        catch (NoSuchEntityException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new EJBException(e2);
                }
            }
            catch (Throwable throwable) {
                BasicBmpBean.close(stmt);
                BasicBmpBean.close(con);
                throw throwable;
            }
        }
        BasicBmpBean.close(stmt);
        BasicBmpBean.close(con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ejbRemove() throws RemoveException, EJBException, RemoteException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            con = ds.getConnection();
            stmt = con.prepareStatement("delete from entity where id = ?");
            Integer primaryKey = (Integer)this.ejbContext.getPrimaryKey();
            stmt.setInt(1, primaryKey);
            if (stmt.executeUpdate() != 1) {
                throw new NoSuchEntityException("Entity not found " + primaryKey);
            }
        }
        catch (NoSuchEntityException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new EJBException(e2);
                }
            }
            catch (Throwable throwable) {
                BasicBmpBean.close(stmt);
                BasicBmpBean.close(con);
                throw throwable;
            }
        }
        BasicBmpBean.close(stmt);
        BasicBmpBean.close(con);
    }

    public void ejbActivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbActivate");
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbPassivate");
    }

    protected void testAllowedOperations(String methodName) {
        InitialContext jndiContext;
        OperationsPolicy policy = new OperationsPolicy();
        try {
            this.ejbContext.getEJBHome();
            policy.allow(0);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getCallerPrincipal();
            policy.allow(1);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.isCallerInRole("ROLE");
            policy.allow(2);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getRollbackOnly();
            policy.allow(3);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.setRollbackOnly();
            policy.allow(4);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getUserTransaction();
            policy.allow(5);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getEJBObject();
            policy.allow(6);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            jndiContext.lookup("java:comp/env/entity/references/JNDI_access_to_java_comp_env");
            policy.allow(8);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            jndiContext.lookup("java:comp/env/entity/references/Resource_manager_access");
            policy.allow(9);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            jndiContext.lookup("java:comp/env/entity/beanReferences/Enterprise_bean_access");
            policy.allow(10);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.allowedOperationsTable.put(methodName, policy);
    }

    private static void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void close(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

