/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateless;

import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.openejb.test.ApplicationException;
import org.openejb.test.object.OperationsPolicy;
import org.openejb.test.stateless.BasicStatelessObject;

public class BasicStatelessBean
implements SessionBean {
    private String name;
    private SessionContext ejbContext;
    private Hashtable allowedOperationsTable = new Hashtable();

    public String businessMethod(String text) {
        this.testAllowedOperations("businessMethod");
        StringBuffer b = new StringBuffer(text);
        return b.reverse().toString();
    }

    public void throwApplicationException() throws ApplicationException {
        throw new ApplicationException("Testing ability to throw Application Exceptions");
    }

    public void throwSystemException_NullPointer() {
        throw new NullPointerException("Testing ability to throw System Exceptions");
    }

    public Properties getPermissionsReport() {
        return null;
    }

    public OperationsPolicy getAllowedOperationsReport(String methodName) {
        return (OperationsPolicy)this.allowedOperationsTable.get(methodName);
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.ejbContext = ctx;
        this.testAllowedOperations("setSessionContext");
    }

    public void ejbCreate() throws CreateException {
        this.testAllowedOperations("ejbCreate");
        this.name = "nameless automaton";
    }

    public void ejbRemove() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbRemove");
    }

    public void ejbActivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbActivate");
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbPassivate");
    }

    protected void testAllowedOperations(String methodName) {
        InitialContext jndiContext;
        OperationsPolicy policy = new OperationsPolicy();
        try {
            this.ejbContext.getEJBHome();
            policy.allow(0);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getCallerPrincipal();
            policy.allow(1);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.isCallerInRole("ROLE");
            policy.allow(2);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getRollbackOnly();
            policy.allow(3);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.setRollbackOnly();
            policy.allow(4);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getUserTransaction();
            policy.allow(5);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getEJBObject();
            policy.allow(6);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            String actual = (String)jndiContext.lookup("java:comp/env/stateless/references/JNDI_access_to_java_comp_env");
            policy.allow(8);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/stateless/references/Resource_manager_access");
            policy.allow(9);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            Object obj = jndiContext.lookup("java:comp/env/stateless/beanReferences/Enterprise_bean_access");
            policy.allow(10);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.allowedOperationsTable.put(methodName, policy);
    }

    public void accessBMTBean() throws EJBException {
        UserTransaction ut = this.ejbContext.getUserTransaction();
        try {
            ut.begin();
        }
        catch (NotSupportedException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw new EJBException((Exception)((Object)e));
        }
        try {
            BasicStatelessObject other = (BasicStatelessObject)this.ejbContext.getEJBObject();
            other.businessMethod("foo");
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        try {
            ut.commit();
        }
        catch (HeuristicMixedException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (HeuristicRollbackException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RollbackException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }
}

