/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.entity.cmp2.cmrmapping;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TransactionRolledbackLocalException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.openejb.test.TestFailureException;
import org.openejb.test.entity.cmp2.cmrmapping.CompoundPK;
import org.openejb.test.entity.cmp2.cmrmapping.ManyOwningSideLocal;
import org.openejb.test.entity.cmp2.cmrmapping.ManyOwningSideLocalHome;
import org.openejb.test.entity.cmp2.cmrmapping.OneInverseSideLocal;
import org.openejb.test.entity.cmp2.cmrmapping.OneInverseSideLocalHome;
import org.openejb.test.entity.cmp2.cmrmapping.OneOwningSideLocal;
import org.openejb.test.entity.cmp2.cmrmapping.OneOwningSideLocalHome;

public class CMRMappingFacadeBean
implements SessionBean {
    private InitialContext jndiContext;
    private SessionContext ctx;
    private CompoundPK compoundPK_20_10;
    private CompoundPK compoundPK_20_20;

    public void testOneToOneSetCMROnOwningSide() throws TestFailureException {
        UserTransaction userTransaction = this.ctx.getUserTransaction();
        try {
            userTransaction.begin();
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10.field1);
            OneOwningSideLocal owningLocal = this.createOneOwningSide(this.compoundPK_20_10);
            owningLocal.setOneInverseSide(inverseLocal);
            userTransaction.commit();
            this.validateOneToOneRelationship(userTransaction);
            this.removeOneToOne(userTransaction);
        }
        catch (Throwable e) {
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void testOneToOneSetCMROnOwningSideResetPK() throws TestFailureException {
        UserTransaction userTransaction = this.ctx.getUserTransaction();
        try {
            userTransaction.begin();
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10.field1);
            OneOwningSideLocal owningLocal = this.createOneOwningSide(this.compoundPK_20_20);
            owningLocal.setOneInverseSide(inverseLocal);
            Assert.fail();
        }
        catch (TransactionRolledbackLocalException e) {
            if (!(e.getCause() instanceof IllegalStateException)) {
                throw new TestFailureException(new AssertionFailedError("Received Exception " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
            }
            try {
                userTransaction.rollback();
            }
            catch (Exception e1) {
                throw new TestFailureException(new AssertionFailedError("Should not happen"));
            }
        }
        catch (Throwable e) {
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void testOneToOneSetCMROnInverseSide() throws TestFailureException {
        UserTransaction userTransaction = this.ctx.getUserTransaction();
        try {
            userTransaction.begin();
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10.field1);
            OneOwningSideLocal owningLocal = this.createOneOwningSide(this.compoundPK_20_10);
            inverseLocal.setOneOwningSide(owningLocal);
            userTransaction.commit();
            this.validateOneToOneRelationship(userTransaction);
            this.removeOneToOne(userTransaction);
        }
        catch (Throwable e) {
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void testOneToOneSetCMROnInverseSideResetPK() throws TestFailureException {
        UserTransaction userTransaction = this.ctx.getUserTransaction();
        try {
            userTransaction.begin();
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10.field1);
            OneOwningSideLocal owningLocal = this.createOneOwningSide(this.compoundPK_20_20);
            inverseLocal.setOneOwningSide(owningLocal);
            Assert.fail();
        }
        catch (TransactionRolledbackLocalException e) {
            if (!(e.getCause() instanceof IllegalStateException)) {
                throw new TestFailureException(new AssertionFailedError("Received Exception " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
            }
            try {
                userTransaction.rollback();
            }
            catch (Exception e1) {
                throw new TestFailureException(new AssertionFailedError("Should not happen"));
            }
        }
        catch (Throwable e) {
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void testOneToOneDoNotSetCMR() throws TestFailureException {
        UserTransaction userTransaction = this.ctx.getUserTransaction();
        try {
            userTransaction.begin();
            this.createOneOwningSide(this.compoundPK_20_10);
            userTransaction.commit();
            Assert.fail();
        }
        catch (IllegalStateException e) {
        }
        catch (Throwable e) {
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void testOneToManySetCMROnOwningSide() throws TestFailureException {
        UserTransaction userTransaction = this.ctx.getUserTransaction();
        try {
            userTransaction.begin();
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10.field1);
            ManyOwningSideLocal owningLocal = this.createManyOwningSide(this.compoundPK_20_10);
            owningLocal.setOneInverseSide(inverseLocal);
            userTransaction.commit();
            this.validateOneToManyRelationship(userTransaction);
            this.removeOneToMany(userTransaction);
        }
        catch (Throwable e) {
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void testOneToManySetCMROnOwningSideResetPK() throws TestFailureException {
        UserTransaction userTransaction = this.ctx.getUserTransaction();
        try {
            userTransaction.begin();
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10.field1);
            ManyOwningSideLocal owningLocal = this.createManyOwningSide(this.compoundPK_20_20);
            owningLocal.setOneInverseSide(inverseLocal);
            Assert.fail();
        }
        catch (TransactionRolledbackLocalException e) {
            if (!(e.getCause() instanceof IllegalStateException)) {
                throw new TestFailureException(new AssertionFailedError("Received Exception " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
            }
            try {
                userTransaction.rollback();
            }
            catch (Exception e1) {
                throw new TestFailureException(new AssertionFailedError("Should not happen"));
            }
        }
        catch (Throwable e) {
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void testOneToManySetCMROnInverseSide() throws TestFailureException {
        UserTransaction userTransaction = this.ctx.getUserTransaction();
        try {
            userTransaction.begin();
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10.field1);
            ManyOwningSideLocal owningLocal = this.createManyOwningSide(this.compoundPK_20_10);
            inverseLocal.setManyOwningSide(Collections.singleton(owningLocal));
            userTransaction.commit();
            this.validateOneToManyRelationship(userTransaction);
            this.removeOneToMany(userTransaction);
        }
        catch (Throwable e) {
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void testOneToManySetCMROnInverseSideResetPK() throws TestFailureException {
        UserTransaction userTransaction = this.ctx.getUserTransaction();
        try {
            userTransaction.begin();
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10.field1);
            ManyOwningSideLocal owningLocal = this.createManyOwningSide(this.compoundPK_20_20);
            inverseLocal.setManyOwningSide(Collections.singleton(owningLocal));
            Assert.fail();
        }
        catch (TransactionRolledbackLocalException e) {
            if (!(e.getCause() instanceof IllegalStateException)) {
                throw new TestFailureException(new AssertionFailedError("Received Exception " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
            }
            try {
                userTransaction.rollback();
            }
            catch (Exception e1) {
                throw new TestFailureException(new AssertionFailedError("Should not happen"));
            }
        }
        catch (Throwable e) {
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void testOneToManyDoNotSetCMR() throws TestFailureException {
        UserTransaction userTransaction = this.ctx.getUserTransaction();
        try {
            userTransaction.begin();
            this.createManyOwningSide(this.compoundPK_20_10);
            userTransaction.commit();
            Assert.fail();
        }
        catch (IllegalStateException e) {
        }
        catch (Throwable e) {
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void ejbCreate() throws CreateException {
        try {
            this.jndiContext = new InitialContext();
            this.compoundPK_20_10 = new CompoundPK(new Integer(20), new Integer(10));
            this.compoundPK_20_20 = new CompoundPK(new Integer(20), new Integer(20));
        }
        catch (Exception e) {
            throw new CreateException("Can not get the initial context: " + e.getMessage());
        }
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.ctx = ctx;
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    private OneInverseSideLocal createOneInverseSide(Integer id) throws Exception {
        OneInverseSideLocalHome home = (OneInverseSideLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/OneInverseSideLocalHome"), (Class)OneInverseSideLocalHome.class);
        return home.create(id);
    }

    private OneInverseSideLocal findOneInverseSide(Integer id) throws Exception {
        OneInverseSideLocalHome home = (OneInverseSideLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/OneInverseSideLocalHome"), (Class)OneInverseSideLocalHome.class);
        return home.findByPrimaryKey(id);
    }

    private void removeOneInverseSide(Integer id) throws Exception {
        this.findOneInverseSide(id).remove();
    }

    private void validateOneToOneRelationship(UserTransaction userTransaction) throws Exception {
        OneInverseSideLocal inverseLocal = this.findOneInverseSide(this.compoundPK_20_10.field1);
        userTransaction.begin();
        Assert.assertEquals((Object)this.compoundPK_20_10, (Object)inverseLocal.getOneOwningSide().getPrimaryKey());
        userTransaction.commit();
    }

    private void removeOneToOne(UserTransaction userTransaction) throws NotSupportedException, SystemException, Exception, HeuristicMixedException, HeuristicRollbackException, RollbackException {
        userTransaction.begin();
        this.removeOneOwningSide(this.compoundPK_20_10);
        this.removeOneInverseSide(this.compoundPK_20_10.field1);
        userTransaction.commit();
    }

    private OneOwningSideLocal createOneOwningSide(CompoundPK compoundPK) throws Exception {
        OneOwningSideLocalHome home = (OneOwningSideLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/OneOwningSideLocalHome"), (Class)OneOwningSideLocalHome.class);
        return home.create(compoundPK.id, compoundPK.field1);
    }

    private OneOwningSideLocal findOneOwningSide(CompoundPK compoundPK) throws Exception {
        OneOwningSideLocalHome home = (OneOwningSideLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/OneOwningSideLocalHome"), (Class)OneOwningSideLocalHome.class);
        return home.findByPrimaryKey(compoundPK);
    }

    private void removeOneOwningSide(CompoundPK compoundPK) throws Exception {
        this.findOneOwningSide(compoundPK).remove();
    }

    private ManyOwningSideLocal createManyOwningSide(CompoundPK compoundPK) throws Exception {
        ManyOwningSideLocalHome home = (ManyOwningSideLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/ManyOwningSideLocalHome"), (Class)ManyOwningSideLocalHome.class);
        return home.create(compoundPK.id, compoundPK.field1);
    }

    private ManyOwningSideLocal findManyOwningSide(CompoundPK compoundPK) throws Exception {
        ManyOwningSideLocalHome home = (ManyOwningSideLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/ManyOwningSideLocalHome"), (Class)ManyOwningSideLocalHome.class);
        return home.findByPrimaryKey(compoundPK);
    }

    private void removeManyOwningSide(CompoundPK compoundPK) throws Exception {
        this.findManyOwningSide(compoundPK).remove();
    }

    private void validateOneToManyRelationship(UserTransaction userTransaction) throws NotSupportedException, SystemException, Exception, HeuristicMixedException, HeuristicRollbackException, RollbackException {
        OneInverseSideLocal inverseLocal = this.findOneInverseSide(this.compoundPK_20_10.field1);
        userTransaction.begin();
        Set set = inverseLocal.getManyOwningSide();
        Assert.assertEquals((int)1, (int)set.size());
        ManyOwningSideLocal owningLocal = (ManyOwningSideLocal)set.iterator().next();
        Assert.assertEquals((Object)this.compoundPK_20_10, (Object)owningLocal.getPrimaryKey());
        userTransaction.commit();
    }

    private void removeOneToMany(UserTransaction userTransaction) throws NotSupportedException, SystemException, Exception, HeuristicMixedException, HeuristicRollbackException, RollbackException {
        userTransaction.begin();
        this.removeManyOwningSide(this.compoundPK_20_10);
        this.removeOneInverseSide(this.compoundPK_20_10.field1);
        userTransaction.commit();
    }
}

