/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.entity.cmp2.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public abstract class StorageBean
implements EntityBean {
    private EntityContext ctx;

    public abstract Integer getId();

    public abstract void setId(Integer var1);

    public abstract byte[] getBlob();

    public abstract void setBlob(byte[] var1);

    public void setBytes(byte[] bytes) {
        try {
            DataSource ds = (DataSource)new InitialContext().lookup("java:comp/env/jdbc/DefaultDatabase");
            Connection c = ds.getConnection();
            PreparedStatement ps = c.prepareStatement("UPDATE storage SET blob_column = ? WHERE id = ?");
            ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
            ps.setInt(2, (Integer)this.ctx.getPrimaryKey());
            ps.executeUpdate();
            ps.close();
            c.close();
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public byte[] getBytes() {
        try {
            int count;
            DataSource ds = (DataSource)new InitialContext().lookup("java:comp/env/jdbc/DefaultDatabase");
            Connection c = ds.getConnection();
            PreparedStatement ps = c.prepareStatement("SELECT blob_column FROM storage WHERE id = ?");
            ps.setInt(1, (Integer)this.ctx.getPrimaryKey());
            ResultSet rs = ps.executeQuery();
            rs.next();
            InputStream is = rs.getBinaryStream(1);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((count = is.read(buffer)) > 0) {
                os.write(buffer, 0, count);
            }
            is.close();
            os.close();
            rs.close();
            ps.close();
            c.close();
            return os.toByteArray();
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public Integer ejbCreate(Integer id) throws CreateException {
        this.setId(id);
        return null;
    }

    public void ejbPostCreate(Integer id) {
    }

    public void ejbLoad() {
    }

    public void setEntityContext(EntityContext ctx) {
        this.ctx = ctx;
    }

    public void unsetEntityContext() {
        this.ctx = null;
    }

    public void ejbStore() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }
}

