/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.entity.cmp2.prefetch;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.openejb.test.TestFailureException;
import org.openejb.test.entity.cmp2.model.AddressLocal;
import org.openejb.test.entity.cmp2.model.AddressLocalHome;
import org.openejb.test.entity.cmp2.model.LineItemLocal;
import org.openejb.test.entity.cmp2.model.LineItemLocalHome;
import org.openejb.test.entity.cmp2.model.OrderLocal;
import org.openejb.test.entity.cmp2.model.OrderLocalHome;
import org.openejb.test.entity.cmp2.model.ProductLocal;
import org.openejb.test.entity.cmp2.model.ProductLocalHome;

public class PrefetchFacadeBean
implements SessionBean {
    private InitialContext jndiContext;
    private SessionContext ctx;

    public void testDoesNotOverwriteUpdates() throws TestFailureException {
        TestAction action = new TestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void executeTest(UserTransaction userTransaction) throws Exception {
                userTransaction.begin();
                try {
                    OrderLocalHome home = (OrderLocalHome)PortableRemoteObject.narrow((Object)PrefetchFacadeBean.this.jndiContext.lookup("java:comp/env/ejb/Order"), (Class)(class$org$openejb$test$entity$cmp2$model$OrderLocalHome == null ? (class$org$openejb$test$entity$cmp2$model$OrderLocalHome = PrefetchFacadeBean.class$("org.openejb.test.entity.cmp2.model.OrderLocalHome")) : class$org$openejb$test$entity$cmp2$model$OrderLocalHome));
                    Integer orderId = new Integer(1);
                    OrderLocal order = home.findByPrimaryKey(orderId);
                    order.setReference("new Reference");
                    order.setBillingAddress(null);
                    order.setShippingAddress(null);
                    order.setLineItems(new HashSet());
                    order = home.findPrefetchAll(orderId);
                    Assert.assertEquals((String)"new Reference", (String)order.getReference());
                    Assert.assertNull((Object)order.getBillingAddress());
                    Assert.assertNull((Object)order.getShippingAddress());
                    Assert.assertEquals((int)0, (int)order.getLineItems().size());
                }
                finally {
                    userTransaction.commit();
                }
            }
        };
        TestTemplate template = new TestTemplate(action);
        template.execute();
    }

    public void testFinderPrefetch() throws TestFailureException {
        TestAction action = new TestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void executeTest(UserTransaction userTransaction) throws Exception {
                userTransaction.begin();
                try {
                    OrderLocalHome home = (OrderLocalHome)PortableRemoteObject.narrow((Object)PrefetchFacadeBean.this.jndiContext.lookup("java:comp/env/ejb/Order"), (Class)(class$org$openejb$test$entity$cmp2$model$OrderLocalHome == null ? (class$org$openejb$test$entity$cmp2$model$OrderLocalHome = PrefetchFacadeBean.class$("org.openejb.test.entity.cmp2.model.OrderLocalHome")) : class$org$openejb$test$entity$cmp2$model$OrderLocalHome));
                    Integer orderId = new Integer(1);
                    OrderLocal order = home.findPrefetchAll(orderId);
                    PrefetchFacadeBean.this.validatePrefetch(order);
                }
                finally {
                    userTransaction.commit();
                }
            }
        };
        TestTemplate template = new TestTemplate(action);
        template.execute();
    }

    public void testEJBPrefetch() throws TestFailureException {
        TestAction action = new TestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void executeTest(UserTransaction userTransaction) throws Exception {
                userTransaction.begin();
                try {
                    LineItemLocalHome home = (LineItemLocalHome)PortableRemoteObject.narrow((Object)PrefetchFacadeBean.this.jndiContext.lookup("java:comp/env/ejb/LineItem"), (Class)(class$org$openejb$test$entity$cmp2$model$LineItemLocalHome == null ? (class$org$openejb$test$entity$cmp2$model$LineItemLocalHome = PrefetchFacadeBean.class$("org.openejb.test.entity.cmp2.model.LineItemLocalHome")) : class$org$openejb$test$entity$cmp2$model$LineItemLocalHome));
                    Integer orderId = new Integer(1);
                    LineItemLocal lineItem = home.findByPrimaryKey(orderId);
                    Assert.assertEquals((int)10, (int)lineItem.getQuantity());
                    DataSource ds = (DataSource)PrefetchFacadeBean.this.jndiContext.lookup("java:comp/env/jdbc/CMPDatasource");
                    Connection con = ds.getConnection();
                    Statement statement = con.createStatement();
                    int nbUpdates = statement.executeUpdate("UPDATE product SET name = ''");
                    Assert.assertEquals((int)1, (int)nbUpdates);
                    ProductLocal product = lineItem.getProduct();
                    Assert.assertEquals((String)"product_name1", (String)product.getName());
                    Assert.assertEquals((String)"product_type1", (String)product.getProductType());
                }
                finally {
                    userTransaction.commit();
                }
            }
        };
        TestTemplate template = new TestTemplate(action);
        template.execute();
    }

    public void testCMPPrefetch() throws TestFailureException {
        TestAction action = new TestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void executeTest(UserTransaction userTransaction) throws Exception {
                userTransaction.begin();
                try {
                    OrderLocalHome home = (OrderLocalHome)PortableRemoteObject.narrow((Object)PrefetchFacadeBean.this.jndiContext.lookup("java:comp/env/ejb/Order"), (Class)(class$org$openejb$test$entity$cmp2$model$OrderLocalHome == null ? (class$org$openejb$test$entity$cmp2$model$OrderLocalHome = PrefetchFacadeBean.class$("org.openejb.test.entity.cmp2.model.OrderLocalHome")) : class$org$openejb$test$entity$cmp2$model$OrderLocalHome));
                    Integer orderId = new Integer(1);
                    OrderLocal order = home.findByPrimaryKey(orderId);
                    Assert.assertEquals((String)"order1", (String)order.getReference());
                    PrefetchFacadeBean.this.validatePrefetch(order);
                }
                finally {
                    userTransaction.commit();
                }
            }
        };
        TestTemplate template = new TestTemplate(action);
        template.execute();
    }

    public void testCMRPrefetch() throws TestFailureException {
        TestAction action = new TestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void executeTest(UserTransaction userTransaction) throws Exception {
                userTransaction.begin();
                try {
                    OrderLocalHome home = (OrderLocalHome)PortableRemoteObject.narrow((Object)PrefetchFacadeBean.this.jndiContext.lookup("java:comp/env/ejb/Order"), (Class)(class$org$openejb$test$entity$cmp2$model$OrderLocalHome == null ? (class$org$openejb$test$entity$cmp2$model$OrderLocalHome = PrefetchFacadeBean.class$("org.openejb.test.entity.cmp2.model.OrderLocalHome")) : class$org$openejb$test$entity$cmp2$model$OrderLocalHome));
                    Integer orderId = new Integer(1);
                    OrderLocal order = home.findByPrimaryKey(orderId);
                    order.getBillingAddress();
                    PrefetchFacadeBean.this.validatePrefetch(order);
                }
                finally {
                    userTransaction.commit();
                }
            }
        };
        TestTemplate template = new TestTemplate(action);
        template.execute();
    }

    public void ejbCreate() throws CreateException {
        try {
            this.jndiContext = new InitialContext();
        }
        catch (Exception e) {
            throw new CreateException("Can not get the initial context: " + e.getMessage());
        }
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.ctx = ctx;
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    private void setUp() throws AssertionFailedError {
        try {
            ProductLocalHome productHome = (ProductLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/Product"), (Class)ProductLocalHome.class);
            ProductLocal product1 = productHome.create(new Integer(1), "product_name1", "product_type1");
            LineItemLocalHome lineItemHome = (LineItemLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/LineItem"), (Class)LineItemLocalHome.class);
            LineItemLocal lineItem1 = lineItemHome.create(new Integer(1), 10);
            LineItemLocal lineItem2 = lineItemHome.create(new Integer(2), 20);
            OrderLocalHome orderHome = (OrderLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/Order"), (Class)OrderLocalHome.class);
            OrderLocal order1 = orderHome.create(new Integer(1), "order1");
            AddressLocalHome addressHome = (AddressLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/Address"), (Class)AddressLocalHome.class);
            AddressLocal address1 = addressHome.create(new Integer(1), "street1", "city1");
            AddressLocal address2 = addressHome.create(new Integer(2), "street2", "city2");
            Set productLineItems = product1.getLineItems();
            productLineItems.add(lineItem1);
            productLineItems.add(lineItem2);
            Set order1LineItems = order1.getLineItems();
            order1LineItems.add(lineItem1);
            order1LineItems.add(lineItem2);
            order1.setBillingAddress(address1);
            order1.setShippingAddress(address2);
        }
        catch (Exception e) {
            throw (AssertionFailedError)new AssertionFailedError(e.getMessage()).initCause((Throwable)e);
        }
    }

    private void cleanUp() throws AssertionFailedError {
        try {
            ProductLocalHome productHome = (ProductLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/Product"), (Class)ProductLocalHome.class);
            productHome.findByPrimaryKey(new Integer(1)).remove();
            LineItemLocalHome lineItemHome = (LineItemLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/LineItem"), (Class)LineItemLocalHome.class);
            lineItemHome.findByPrimaryKey(new Integer(1)).remove();
            lineItemHome.findByPrimaryKey(new Integer(2)).remove();
            OrderLocalHome orderHome = (OrderLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/Order"), (Class)OrderLocalHome.class);
            orderHome.findByPrimaryKey(new Integer(1)).remove();
            AddressLocalHome addressHome = (AddressLocalHome)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/ejb/Address"), (Class)AddressLocalHome.class);
            addressHome.findByPrimaryKey(new Integer(1)).remove();
            addressHome.findByPrimaryKey(new Integer(2)).remove();
        }
        catch (FinderException e) {
            throw (AssertionFailedError)new AssertionFailedError(e.getMessage()).initCause((Throwable)e);
        }
        catch (NamingException e) {
            throw (AssertionFailedError)new AssertionFailedError(e.getMessage()).initCause((Throwable)e);
        }
        catch (RemoveException e) {
            throw (AssertionFailedError)new AssertionFailedError(e.getMessage()).initCause((Throwable)e);
        }
    }

    private void validatePrefetch(OrderLocal order) throws NamingException, SQLException {
        DataSource ds = (DataSource)this.jndiContext.lookup("java:comp/env/jdbc/CMPDatasource");
        Connection con = ds.getConnection();
        Statement statement = con.createStatement();
        int nbUpdates = statement.executeUpdate("UPDATE order_table SET reference = ''");
        Assert.assertEquals((int)1, (int)nbUpdates);
        nbUpdates = statement.executeUpdate("UPDATE address SET street = ''");
        Assert.assertEquals((int)2, (int)nbUpdates);
        nbUpdates = statement.executeUpdate("UPDATE line_item SET quantity = 0");
        Assert.assertEquals((int)2, (int)nbUpdates);
        nbUpdates = statement.executeUpdate("UPDATE product SET name = ''");
        Assert.assertEquals((int)1, (int)nbUpdates);
        Assert.assertEquals((String)"order1", (String)order.getReference());
        AddressLocal address = order.getBillingAddress();
        Assert.assertEquals((String)"street1", (String)address.getStreet());
        Assert.assertEquals((String)"city1", (String)address.getCity());
        address = order.getShippingAddress();
        Assert.assertEquals((String)"street2", (String)address.getStreet());
        Assert.assertEquals((String)"city2", (String)address.getCity());
        int cpt = 0;
        Set lineItems = order.getLineItems();
        Iterator iter = lineItems.iterator();
        while (iter.hasNext()) {
            LineItemLocal lineItem = (LineItemLocal)iter.next();
            int quantity = lineItem.getQuantity();
            Assert.assertTrue((10 == lineItem.getQuantity() || 20 == lineItem.getQuantity() ? 1 : 0) != 0);
            ProductLocal product = lineItem.getProduct();
            Assert.assertEquals((String)"product_name1", (String)product.getName());
            Assert.assertEquals((String)"product_type1", (String)product.getProductType());
            ++cpt;
        }
        Assert.assertEquals((int)2, (int)cpt);
    }

    private class TestTemplate {
        private final TestAction action;

        private TestTemplate(TestAction action) {
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void execute() throws TestFailureException {
            block11: {
                UserTransaction userTransaction = PrefetchFacadeBean.this.ctx.getUserTransaction();
                try {
                    userTransaction.begin();
                    PrefetchFacadeBean.this.setUp();
                    userTransaction.commit();
                }
                catch (Exception e) {
                    Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
                }
                this.action.executeTest(userTransaction);
                Object var4_5 = null;
                try {
                    userTransaction.begin();
                    PrefetchFacadeBean.this.cleanUp();
                    userTransaction.commit();
                }
                catch (Exception e2) {
                    Assert.fail((String)("Received Exception " + e2.getClass() + " : " + e2.getMessage()));
                }
                break block11;
                {
                    catch (AssertionFailedError e) {
                        throw new TestFailureException(e);
                    }
                    catch (Throwable e) {
                        Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
                        Object var4_6 = null;
                        try {
                            userTransaction.begin();
                            PrefetchFacadeBean.this.cleanUp();
                            userTransaction.commit();
                        }
                        catch (Exception e2) {
                            Assert.fail((String)("Received Exception " + e2.getClass() + " : " + e2.getMessage()));
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    try {
                        userTransaction.begin();
                        PrefetchFacadeBean.this.cleanUp();
                        userTransaction.commit();
                    }
                    catch (Exception e2) {
                        Assert.fail((String)("Received Exception " + e2.getClass() + " : " + e2.getMessage()));
                    }
                    throw throwable;
                }
            }
        }
    }

    private static interface TestAction {
        public void executeTest(UserTransaction var1) throws Exception;
    }
}

