/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.openejb.test.TestDatabase;
import org.openejb.test.TestManager;
import org.openejb.test.beans.Database;
import org.openejb.test.beans.DatabaseHome;

public class AxionTestDatabase
implements TestDatabase {
    protected Database database;
    protected InitialContext initialContext;
    private static final String CREATE_ACCOUNT = "CREATE TABLE account ( ssn string, first_name string, last_name string, balance integer)";
    private static final String DROP_ACCOUNT = "DROP TABLE account";
    private static final String CREATE_ENTITY = "CREATE TABLE entity ( id integer default entity_seq.nextval, first_name string, last_name string )";
    private static final String DROP_ENTITY = "DROP TABLE entity";
    private static final String CREATE_BASICCMP = "CREATE TABLE BASICCMP ( id integer default entity_seq.nextval, firstname string, lastname string )";
    private static final String DROP_BASICCMP = "DROP TABLE BASICCMP";
    private static final String CREATE_AOBASICCMP = "CREATE TABLE AOBASICCMP ( id integer default entity_seq.nextval, firstname string, lastname string )";
    private static final String DROP_AOBASICCMP = "DROP TABLE AOBASICCMP";
    private static final String CREATE_ENCCMP = "CREATE TABLE ENCCMP ( id integer default entity_seq.nextval, firstname string, lastname string )";
    private static final String DROP_ENCCMP = "DROP TABLE ENCCMP";
    private static final String CREATE_CMPRMIIIOP = "CREATE TABLE CMPRMIIIOP ( id integer default entity_seq.nextval, firstname string, lastname string )";
    private static final String DROP_CMPRMIIIOP = "DROP TABLE CMPRMIIIOP";
    private static final String CREATE_ENTITY_SEQ = "CREATE SEQUENCE entity_seq";
    private static final String DROP_ENTITY_SEQ = "DROP SEQUENCE entity_seq";

    public void createEntityTable() throws SQLException {
        this.executeStatementIgnoreErrors(DROP_CMPRMIIIOP);
        this.executeStatementIgnoreErrors(DROP_ENCCMP);
        this.executeStatementIgnoreErrors(DROP_BASICCMP);
        this.executeStatementIgnoreErrors(DROP_AOBASICCMP);
        this.executeStatementIgnoreErrors(DROP_ENTITY);
        this.executeStatementIgnoreErrors(DROP_ENTITY_SEQ);
        this.executeStatement(CREATE_ENTITY_SEQ);
        this.executeStatement(CREATE_ENTITY);
        this.executeStatement(CREATE_BASICCMP);
        this.executeStatement(CREATE_AOBASICCMP);
        this.executeStatement(CREATE_ENCCMP);
        this.executeStatement(CREATE_CMPRMIIIOP);
    }

    public void dropEntityTable() throws SQLException {
        this.executeStatement(DROP_CMPRMIIIOP);
        this.executeStatement(DROP_ENCCMP);
        this.executeStatement(DROP_BASICCMP);
        this.executeStatement(DROP_AOBASICCMP);
        this.executeStatement(DROP_ENTITY);
        this.executeStatement(DROP_ENTITY_SEQ);
    }

    private void executeStatementIgnoreErrors(String command) {
        try {
            this.getDatabase().execute(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void executeStatement(String command) throws SQLException {
        try {
            this.getDatabase().execute(command);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Cannot exectute statement: " + re.getMessage(), command);
        }
    }

    public void createAccountTable() throws SQLException {
        this.executeStatementIgnoreErrors(DROP_ACCOUNT);
        this.executeStatement(CREATE_ACCOUNT);
    }

    public void dropAccountTable() throws SQLException {
        this.executeStatement(DROP_ACCOUNT);
    }

    public void start() throws IllegalStateException {
        try {
            Properties properties = TestManager.getServer().getContextEnvironment();
            this.initialContext = new InitialContext(properties);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create initial context: " + e.getClass().getName() + " " + e.getMessage());
        }
    }

    private Database getDatabase() {
        if (this.database == null) {
            this.database = this.createDatabaseObject();
        }
        return this.database;
    }

    private Database createDatabaseObject() {
        Object obj = null;
        DatabaseHome databaseHome = null;
        Database database = null;
        try {
            obj = this.initialContext.lookup("client/tools/DatabaseHome");
            databaseHome = (DatabaseHome)PortableRemoteObject.narrow((Object)obj, (Class)DatabaseHome.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot find 'client/tools/DatabaseHome': " + e.getClass().getName() + " " + e.getMessage());
        }
        try {
            database = databaseHome.create();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot start database: " + e.getClass().getName() + " " + e.getMessage());
        }
        return database;
    }

    public void stop() throws IllegalStateException {
    }

    public void init(Properties props) throws IllegalStateException {
    }

    static {
        System.setProperty("noBanner", "true");
    }
}

