/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.test.stateful;

import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.openejb.test.ApplicationException;
import org.openejb.test.object.OperationsPolicy;

public class BMTStatefulBean
implements SessionBean {
    private String name;
    private SessionContext ejbContext;
    private Hashtable allowedOperationsTable = new Hashtable();

    public void ejbCreate(String name) throws CreateException {
        this.testAllowedOperations("ejbCreate");
        this.name = name;
    }

    public void doNothing() {
        this.testAllowedOperations("businessMethod");
    }

    public String businessMethod(String text) {
        StringBuffer b = new StringBuffer(text);
        return b.reverse().toString();
    }

    public void throwApplicationException() throws ApplicationException {
        throw new ApplicationException("Don't Panic");
    }

    public void throwSystemException_NullPointer() {
        throw new NullPointerException("Panic");
    }

    public Properties getPermissionsReport() {
        return null;
    }

    public OperationsPolicy getAllowedOperationsReport(String methodName) {
        return (OperationsPolicy)this.allowedOperationsTable.get(methodName);
    }

    public void setSessionContext(SessionContext ctx) {
        this.ejbContext = ctx;
        this.testAllowedOperations("setSessionContext");
    }

    public void ejbRemove() {
        this.testAllowedOperations("ejbRemove");
    }

    public void ejbActivate() {
        this.testAllowedOperations("ejbActivate");
    }

    public void ejbPassivate() {
        this.testAllowedOperations("ejbPassivate");
    }

    protected void testAllowedOperations(String methodName) {
        InitialContext jndiContext;
        OperationsPolicy policy = new OperationsPolicy();
        try {
            this.ejbContext.getEJBHome();
            policy.allow(0);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getCallerPrincipal();
            policy.allow(1);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.isCallerInRole("ROLE");
            policy.allow(2);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getRollbackOnly();
            policy.allow(3);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.setRollbackOnly();
            policy.allow(4);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getUserTransaction();
            policy.allow(5);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getEJBObject();
            policy.allow(6);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            jndiContext.lookup("java:comp/env/stateful/references/JNDI_access_to_java_comp_env");
            policy.allow(8);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            jndiContext.lookup("java:comp/env/stateful/references/Resource_manager_access");
            policy.allow(9);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            jndiContext = new InitialContext();
            jndiContext.lookup("java:comp/env/stateful/beanReferences/Enterprise_bean_access");
            policy.allow(10);
        }
        catch (IllegalStateException ise) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.allowedOperationsTable.put(methodName, policy);
    }
}

