/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.openejb.loader.Loader;

public class LocalInitialContextFactory
implements InitialContextFactory {
    static Context intraVmContext;

    public Context getInitialContext(Hashtable env) throws NamingException {
        if (intraVmContext == null) {
            try {
                this.getLoader(env).load(env);
            }
            catch (Exception e) {
                throw new NamingException("Attempted to load OpenEJB. " + e.getMessage());
            }
            intraVmContext = this.getIntraVmContext(env);
        }
        return intraVmContext;
    }

    private Loader getLoader(Hashtable env) throws Exception {
        Loader loader = null;
        String type = (String)env.get("openejb.loader");
        try {
            if (type == null || type.equals("context")) {
                loader = this.instantiateLoader("org.openejb.loader.EmbeddingLoader");
            } else if (type.equals("embed")) {
                loader = this.instantiateLoader("org.openejb.loader.EmbeddingLoader");
            } else if (type.equals("system")) {
                loader = this.instantiateLoader("org.openejb.loader.SystemLoader");
            } else if (type.equals("bootstrap")) {
                loader = this.instantiateLoader("org.openejb.loader.SystemLoader");
            } else if (type.equals("noload")) {
                loader = this.instantiateLoader("org.openejb.loader.EmbeddedLoader");
            } else if (type.equals("embedded")) {
                loader = this.instantiateLoader("org.openejb.loader.EmbeddedLoader");
            }
        }
        catch (Exception e) {
            throw new Exception("Loader " + type + ". " + e.getMessage());
        }
        return loader;
    }

    private ClassLoader getClassLoader() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Loader instantiateLoader(String loaderName) throws Exception {
        Loader loader = null;
        try {
            ClassLoader cl = this.getClassLoader();
            Class<?> loaderClass = Class.forName(loaderName, true, cl);
            loader = (Loader)loaderClass.newInstance();
        }
        catch (Exception e) {
            throw new Exception("Could not instantiate the Loader " + loaderName + ". Exception " + e.getClass().getName() + " " + e.getMessage());
        }
        return loader;
    }

    private Context getIntraVmContext(Hashtable env) throws NamingException {
        Context context = null;
        try {
            InitialContextFactory factory = null;
            ClassLoader cl = this.getClassLoader();
            Class<?> ivmFactoryClass = Class.forName("org.openejb.core.ivm.naming.InitContextFactory", true, cl);
            factory = (InitialContextFactory)ivmFactoryClass.newInstance();
            context = factory.getInitialContext(env);
        }
        catch (Exception e) {
            throw new NamingException("Cannot instantiate an IntraVM InitialContext. Exception: " + e.getClass().getName() + " " + e.getMessage());
        }
        return context;
    }
}

