/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.artifact;

import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.opensaml.xml.util.Base64;

public abstract class SAMLArtifact {
    protected SecureRandom randomGen;
    private byte[] typeCode;

    protected SAMLArtifact(byte[] code) {
        this.setTypeCode(code);
        try {
            this.randomGen = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to initialize random number generator", e);
        }
    }

    public byte[] getArtifactBytes() {
        byte[] remainingArtifact = this.getRemainingArtifact();
        byte[] artifact = new byte[2 + remainingArtifact.length];
        System.arraycopy(this.getTypeCode(), 0, artifact, 0, 2);
        System.arraycopy(remainingArtifact, 0, artifact, 2, remainingArtifact.length);
        return artifact;
    }

    public byte[] getTypeCode() {
        return this.typeCode;
    }

    protected void setTypeCode(byte[] newTypeCode) {
        this.typeCode = newTypeCode;
    }

    public abstract byte[] getRemainingArtifact();

    public String base64Encode() {
        return new String(Base64.encodeBytes((byte[])this.getArtifactBytes()));
    }

    public String hexEncode() {
        return new String(Hex.encode((byte[])this.getArtifactBytes()));
    }

    public boolean equals(Object o) {
        if (o instanceof SAMLArtifact) {
            SAMLArtifact otherArtifact = (SAMLArtifact)o;
            return Arrays.equals(this.getArtifactBytes(), otherArtifact.getArtifactBytes());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getArtifactBytes());
    }

    public String toString() {
        return new String(this.getArtifactBytes());
    }
}

