/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.impl;

import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.opensaml.common.impl.AbstractSAMLObjectMarshaller;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.w3c.dom.Element;

public class AuthnStatementMarshaller
extends AbstractSAMLObjectMarshaller {
    public AuthnStatementMarshaller() {
        super("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnStatement");
    }

    protected AuthnStatementMarshaller(String namespaceURI, String elementLocalName) {
        super(namespaceURI, elementLocalName);
    }

    protected void marshallAttributes(XMLObject samlObject, Element domElement) throws MarshallingException {
        AuthnStatement authnStatement = (AuthnStatement)samlObject;
        if (authnStatement.getAuthnInstant() != null) {
            String authnInstantStr = ISODateTimeFormat.dateTime().print((ReadableInstant)authnStatement.getAuthnInstant());
            domElement.setAttributeNS(null, "AuthnInstant", authnInstantStr);
        }
        if (authnStatement.getSessionIndex() != null) {
            domElement.setAttributeNS(null, "SessionIndex", authnStatement.getSessionIndex());
        }
        if (authnStatement.getSessionNotOnOrAfter() != null) {
            String sessionNotOnOrAfterStr = ISODateTimeFormat.dateTime().print((ReadableInstant)authnStatement.getSessionNotOnOrAfter());
            domElement.setAttributeNS(null, "SessionNotOnOrAfter", sessionNotOnOrAfterStr);
        }
    }
}

