/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.opensaml.saml2.common.SAML2Helper;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.BaseMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.DatatypeHelper;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetadataProvider
extends BaseMetadataProvider {
    private static Logger log = Logger.getLogger(AbstractMetadataProvider.class);
    private FastMap<String, EntityDescriptor> indexedDescriptors = new FastMap();
    private ParserPool parser;

    @Override
    public EntitiesDescriptor getEntitiesDescriptor(String name) throws MetadataProviderException {
        XMLObject metadata = this.getMetadata();
        if (metadata instanceof EntitiesDescriptor) {
            EntitiesDescriptor descriptor = (EntitiesDescriptor)metadata;
            return this.getEntitiesDescriptorByName(name, descriptor);
        }
        return null;
    }

    @Override
    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        XMLObject metadata;
        EntityDescriptor descriptor;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting descriptor for entity " + entityID));
        }
        if ((descriptor = this.getEntityDescriptorById(entityID, metadata = this.getMetadata())) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Metadata document does not contain an entity descriptor with the ID " + entityID));
            }
            return null;
        }
        return descriptor;
    }

    @Override
    public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
        EntityDescriptor entity = this.getEntityDescriptor(entityID);
        if (entity != null) {
            return entity.getRoleDescriptors(roleName);
        }
        return null;
    }

    @Override
    public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        List<RoleDescriptor> roles = this.getRole(entityID, roleName);
        if (roles == null) {
            return null;
        }
        for (RoleDescriptor role : roles) {
            if (!role.isSupportedProtocol(supportedProtocol)) continue;
            return role;
        }
        return null;
    }

    public ParserPool getParserPool() {
        return this.parser;
    }

    public void setParserPool(ParserPool pool) {
        this.parser = pool;
    }

    protected void clearDescriptorIndex() {
        this.indexedDescriptors.clear();
    }

    protected XMLObject unmarshallMetadata(InputStream metadataInputstream) throws UnmarshallingException {
        try {
            XMLObject metadata;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Parsing retrieved metadata into a DOM object");
            }
            Document mdDocument = this.parser.parse(metadataInputstream);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unmarshalling and caching metdata DOM");
            }
            Unmarshaller unmarshaller = this.unmarshallerFactory.getUnmarshaller(mdDocument.getDocumentElement());
            XMLObject xMLObject = metadata = unmarshaller.unmarshall(mdDocument.getDocumentElement());
            return xMLObject;
        }
        catch (Exception e) {
            throw new UnmarshallingException(e);
        }
        finally {
            try {
                metadataInputstream.close();
            }
            catch (IOException e) {}
        }
    }

    protected void filterMetadata(XMLObject metadata) throws FilterException {
        if (this.getMetadataFilter() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Applying metadata filter");
            }
            this.getMetadataFilter().doFilter(metadata);
        }
    }

    protected void releaseMetadataDOM(XMLObject metadata) {
        if (metadata != null) {
            metadata.releaseDOM();
            metadata.releaseChildrenDOM(true);
        }
    }

    protected EntityDescriptor getEntityDescriptorById(String entityID, XMLObject metadata) {
        EntityDescriptor descriptor = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for entity descriptor with an entity ID of " + entityID));
        }
        if (this.indexedDescriptors.containsKey((Object)entityID)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity descriptor for the ID " + entityID + " was found in index cache, returning"));
            }
            if (this.isValid((XMLObject)(descriptor = (EntityDescriptor)this.indexedDescriptors.get((Object)entityID)))) {
                return descriptor;
            }
            this.indexedDescriptors.remove((Object)descriptor);
        }
        if (metadata != null) {
            if (metadata instanceof EntityDescriptor) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Metadata root is an entity descriptor, checking if it's the one we're looking for.");
                }
                if (!(descriptor = (EntityDescriptor)metadata).getEntityID().equals(entityID) || !this.isValid((XMLObject)descriptor)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Entity descriptor does not have the correct entity ID or is not valid, returning null");
                    }
                    descriptor = null;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Metadata was an entities descriptor, checking if any of it's descendant entity descriptors is the one we're looking for.");
                }
                if (metadata instanceof EntitiesDescriptor) {
                    descriptor = this.getEntityDescriptorById(entityID, (EntitiesDescriptor)metadata);
                }
            }
        }
        if (descriptor != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Located entity descriptor, creating an index to it for faster lookups");
            }
            this.indexedDescriptors.put((Object)entityID, (Object)descriptor);
        }
        return descriptor;
    }

    protected EntityDescriptor getEntityDescriptorById(String entityID, EntitiesDescriptor descriptor) {
        List<EntitiesDescriptor> entitiesDescriptors;
        List<EntityDescriptor> entityDescriptors;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking to see if any of the child entity descriptors of this entities descriptor is the requested descriptor");
        }
        if ((entityDescriptors = descriptor.getEntityDescriptors()) != null) {
            for (EntityDescriptor entityDescriptor : entityDescriptors) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking entity descriptor with entity ID " + entityDescriptor.getEntityID()));
                }
                if (!entityDescriptor.getEntityID().equals(entityID) || !this.isValid((XMLObject)entityDescriptor)) continue;
                return entityDescriptor;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking to see if any of the child entities descriptors contains the entity descriptor requested");
        }
        if ((entitiesDescriptors = descriptor.getEntitiesDescriptors()) != null) {
            for (EntitiesDescriptor entitiesDescriptor : descriptor.getEntitiesDescriptors()) {
                EntityDescriptor entityDescriptor = this.getEntityDescriptorById(entityID, entitiesDescriptor);
                if (entityDescriptor == null) continue;
                return entityDescriptor;
            }
        }
        return null;
    }

    protected EntitiesDescriptor getEntitiesDescriptorByName(String name, EntitiesDescriptor rootDescriptor) {
        EntitiesDescriptor descriptor = null;
        if (DatatypeHelper.safeEquals((Object)name, (Object)rootDescriptor.getName()) && this.isValid((XMLObject)rootDescriptor)) {
            descriptor = rootDescriptor;
        } else {
            List<EntitiesDescriptor> childDescriptors = rootDescriptor.getEntitiesDescriptors();
            if (childDescriptors != null) {
                for (EntitiesDescriptor childDescriptor : childDescriptors) {
                    if ((childDescriptor = this.getEntitiesDescriptorByName(name, childDescriptor)) == null) continue;
                    descriptor = childDescriptor;
                }
            }
        }
        return descriptor;
    }

    protected boolean isValid(XMLObject descriptor) {
        if (!this.requireValidMetadata()) {
            return true;
        }
        return SAML2Helper.isValid(descriptor);
    }
}

