/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.security.SAMLMDCredentialContext;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.AbstractCriteriaFilteringCredentialResolver;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialCriteriaSet;
import org.opensaml.xml.security.credential.EntityIDCriteria;
import org.opensaml.xml.security.credential.UsageCriteria;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCriteria;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataCredentialResolver
extends AbstractCriteriaFilteringCredentialResolver {
    private static Logger log = Logger.getLogger(MetadataCredentialResolver.class);
    private MetadataProvider metadata;
    private Map<MetadataCacheKey, SoftReference<Collection<Credential>>> cache;
    private KeyInfoCredentialResolver keyInfoCredentialResolver;

    public MetadataCredentialResolver(MetadataProvider metadataProvider) {
        if (metadataProvider == null) {
            throw new IllegalArgumentException("Metadata provider may not be null");
        }
        this.metadata = metadataProvider;
        this.cache = new HashMap<MetadataCacheKey, SoftReference<Collection<Credential>>>();
        if (this.metadata instanceof ObservableMetadataProvider) {
            ObservableMetadataProvider observable = (ObservableMetadataProvider)metadataProvider;
            observable.getObservers().add(new MetadataProviderObserver());
        }
    }

    public KeyInfoCredentialResolver getKeyInfoCredentialResolver() {
        if (this.keyInfoCredentialResolver == null) {
            this.keyInfoCredentialResolver = new KeyInfoCredentialResolver();
        }
        return this.keyInfoCredentialResolver;
    }

    public void setKeyInfoCredentialResolver(KeyInfoCredentialResolver keyInfoResolver) {
        this.keyInfoCredentialResolver = keyInfoResolver;
    }

    protected Iterable<Credential> resolveFromSource(CredentialCriteriaSet criteriaSet) throws SecurityException {
        this.checkCriteriaRequirements(criteriaSet);
        String entityID = ((EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class)).getEntityID();
        MetadataCriteria mdCriteria = (MetadataCriteria)criteriaSet.get(MetadataCriteria.class);
        QName role = mdCriteria.getRole();
        String protocol = mdCriteria.getProtocol();
        UsageCriteria usageCriteria = (UsageCriteria)criteriaSet.get(UsageCriteria.class);
        UsageType usage = null;
        usage = usageCriteria != null ? usageCriteria.getUsage() : UsageType.UNSPECIFIED;
        MetadataCacheKey cacheKey = new MetadataCacheKey(entityID, role, protocol, usage);
        Collection<Credential> credentials = this.retrieveFromCache(cacheKey);
        if (credentials == null) {
            credentials = this.retrieveFromMetadata(entityID, role, protocol, usage);
            this.cacheCredential(cacheKey, credentials);
        }
        return credentials;
    }

    protected void checkCriteriaRequirements(CredentialCriteriaSet criteriaSet) {
        EntityIDCriteria entityCriteria = (EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class);
        MetadataCriteria mdCriteria = (MetadataCriteria)criteriaSet.get(MetadataCriteria.class);
        if (entityCriteria == null) {
            throw new IllegalArgumentException("Entity criteria must be supplied");
        }
        if (mdCriteria == null) {
            throw new IllegalArgumentException("SAML metadata criteria must be supplied");
        }
        if (DatatypeHelper.isEmpty((String)entityCriteria.getEntityID())) {
            throw new IllegalArgumentException("Credential owner entity ID criteria value must be supplied");
        }
        if (mdCriteria.getRole() == null) {
            throw new IllegalArgumentException("Credential metadata role criteria value must be supplied");
        }
    }

    protected Collection<Credential> retrieveFromCache(MetadataCacheKey cacheKey) {
        SoftReference<Collection<Credential>> reference;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to retrieve credentials from cache using index: " + cacheKey));
        }
        if (this.cache.containsKey(cacheKey) && (reference = this.cache.get(cacheKey)).get() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieved credentials from cache using index: " + cacheKey));
            }
            return reference.get();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unable to retrieve credentials from cache using index: " + cacheKey));
        }
        return null;
    }

    protected Collection<Credential> retrieveFromMetadata(String entityID, QName role, String protocol, UsageType usage) throws SecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to retrieve credentials from metadata for entity: " + entityID));
        }
        HashSet<Credential> credentials = new HashSet<Credential>();
        for (RoleDescriptor roleDescriptor : this.getRoleDescriptors(entityID, role, protocol)) {
            List<KeyDescriptor> keyDescriptors = roleDescriptor.getKeyDescriptors();
            for (KeyDescriptor keyDescriptor : keyDescriptors) {
                UsageType mdUsage = keyDescriptor.getUse();
                if (mdUsage == null) {
                    mdUsage = UsageType.UNSPECIFIED;
                }
                if (!this.matchUsage(mdUsage, usage) || keyDescriptor.getKeyInfo() == null) continue;
                CredentialCriteriaSet critSet = new CredentialCriteriaSet();
                critSet.add((Object)new KeyInfoCriteria(keyDescriptor.getKeyInfo()));
                for (Credential cred : this.getKeyInfoCredentialResolver().resolve(critSet)) {
                    if (cred instanceof BasicCredential) {
                        BasicCredential basicCred = (BasicCredential)cred;
                        basicCred.setEntityId(entityID);
                        basicCred.setUsageType(mdUsage);
                        basicCred.getCredentalContextSet().add((Object)new SAMLMDCredentialContext(keyDescriptor));
                    }
                    credentials.add(cred);
                }
            }
        }
        return credentials;
    }

    protected boolean matchUsage(UsageType metadataUsage, UsageType criteriaUsage) {
        if (metadataUsage == UsageType.UNSPECIFIED || criteriaUsage == UsageType.UNSPECIFIED) {
            return true;
        }
        return metadataUsage == criteriaUsage;
    }

    protected List<RoleDescriptor> getRoleDescriptors(String entityID, QName role, String protocol) throws SecurityException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving metadata for entity '" + entityID + "' in role '" + role + "' for protocol '" + protocol + "'"));
            }
            if (DatatypeHelper.isEmpty((String)protocol)) {
                return this.metadata.getRole(entityID, role);
            }
            RoleDescriptor roleDescriptor = this.metadata.getRole(entityID, role, protocol);
            if (roleDescriptor == null) {
                return null;
            }
            ArrayList<RoleDescriptor> roles = new ArrayList<RoleDescriptor>();
            roles.add(roleDescriptor);
            return roles;
        }
        catch (MetadataProviderException e) {
            log.error((Object)"Unable to read metadata from provider", (Throwable)e);
            throw new SecurityException("Unable to read metadata provider", (Exception)e);
        }
    }

    protected void cacheCredential(MetadataCacheKey cacheKey, Collection<Credential> credentials) {
        this.cache.put(cacheKey, new SoftReference<Collection<Credential>>(credentials));
    }

    protected class MetadataProviderObserver
    implements ObservableMetadataProvider.Observer {
        protected MetadataProviderObserver() {
        }

        public void onEvent(MetadataProvider provider) {
            MetadataCredentialResolver.this.cache.clear();
        }
    }

    protected class MetadataCacheKey {
        private String id;
        private QName role;
        private String protocol;
        private UsageType usage;

        protected MetadataCacheKey(String entityID, QName entityRole, String entityProtocol, UsageType entityUsage) {
            if (entityID == null) {
                throw new IllegalArgumentException("Entity ID may not be null");
            }
            if (entityRole == null) {
                throw new IllegalArgumentException("Entity role may not be null");
            }
            if (entityUsage == null) {
                throw new IllegalArgumentException("Credential usage may not be null");
            }
            this.id = entityID;
            this.role = entityRole;
            this.protocol = entityProtocol;
            this.usage = entityUsage;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MetadataCacheKey)) {
                return false;
            }
            MetadataCacheKey other = (MetadataCacheKey)obj;
            if (!this.id.equals(other.id) || !this.role.equals(other.role) || this.usage != other.usage) {
                return false;
            }
            return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.id.hashCode();
            result = 37 * result + this.role.hashCode();
            if (this.protocol != null) {
                result = 37 * result + this.protocol.hashCode();
            }
            result = 37 * result + this.usage.hashCode();
            return result;
        }

        public String toString() {
            return String.format("[%s,%s,%s,%s]", this.id, this.role, this.protocol, this.usage);
        }
    }
}

