/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.joda.time.DateTime;
import org.opensaml.util.resource.ClasspathResource;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.xml.util.DatatypeHelper;

public class FilesystemResource
implements Resource {
    private File resource;

    public FilesystemResource(String resourcePath) throws ResourceException {
        if (DatatypeHelper.isEmpty((String)resourcePath)) {
            throw new ResourceException("Resource path may not be null or empty");
        }
        this.resource = new File(resourcePath);
    }

    public boolean exists() throws ResourceException {
        return this.resource.exists();
    }

    public InputStream getInputStream() throws ResourceException {
        try {
            return new FileInputStream(this.resource);
        }
        catch (FileNotFoundException e) {
            throw new ResourceException("Resource file does not exist: " + this.resource.getAbsolutePath());
        }
    }

    public DateTime getLastModifiedTime() throws ResourceException {
        if (!this.resource.exists()) {
            throw new ResourceException("Resource file does not exist: " + this.resource.getAbsolutePath());
        }
        return new DateTime(this.resource.lastModified());
    }

    public String getLocation() {
        return this.resource.getAbsolutePath();
    }

    public String toString() {
        return this.getLocation();
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof FilesystemResource) {
            return this.getLocation().equals(((ClasspathResource)o).getLocation());
        }
        return false;
    }
}

