/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.storage;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.opensaml.util.storage.ExpiringObject;
import org.opensaml.util.storage.StorageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayCache {
    private static Logger log = Logger.getLogger(ReplayCache.class);
    private StorageService<String, ReplayCacheEntry> storage;
    private long defaultDuration;
    private ReentrantLock lock;

    public ReplayCache(StorageService<String, ReplayCacheEntry> storageService, long duration) {
        this.storage = storageService;
        this.defaultDuration = duration;
        this.lock = new ReentrantLock(true);
    }

    public boolean isReplay(String messageId) {
        return this.isReplay(messageId, this.defaultDuration);
    }

    public boolean isReplay(String messageId, long duration) {
        return this.isReplay(messageId, new DateTime().plus(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplay(String messageId, DateTime expiration) {
        boolean replayed = true;
        log.debug((Object)"Attempting to acquire lock for replay cache check");
        this.lock.lock();
        log.debug((Object)"Lock acquired");
        try {
            ReplayCacheEntry cacheEntry = this.storage.get(messageId);
            if (cacheEntry == null || cacheEntry.isExpired()) {
                if (log.isDebugEnabled()) {
                    if (cacheEntry == null) {
                        log.debug((Object)String.format("Message ID '%s' was not a replay", messageId));
                    } else if (cacheEntry.isExpired()) {
                        log.debug((Object)String.format("Message ID '%s' expired in replay cache at '%s'", messageId, cacheEntry.getExpirationTime().toString()));
                    }
                }
                replayed = false;
                this.addMessageID(messageId, expiration);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Replay of message ID '%s' detected in replay cache, will expire at '%s'", messageId, cacheEntry.getExpirationTime().toString()));
            }
        }
        finally {
            this.lock.unlock();
            log.debug((Object)"Lock released for replay cache check");
        }
        return replayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessageID(String messageId, DateTime expiration) {
        log.debug((Object)"Attempting to acquire lock for replay cache write");
        this.lock.lock();
        log.debug((Object)"Lock acquired");
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Writing message ID '%s' to replay cache with expiration time '%s'", messageId, expiration.toString()));
            }
            this.storage.put(messageId, new ReplayCacheEntry(expiration));
        }
        finally {
            this.lock.unlock();
            log.debug((Object)"Lock released for replay cache write");
        }
    }

    public class ReplayCacheEntry
    implements ExpiringObject,
    Serializable {
        private static final long serialVersionUID = 2398693920546938083L;
        private DateTime expirationTime;

        public ReplayCacheEntry(DateTime expiration) {
            this.expirationTime = expiration;
        }

        public DateTime getExpirationTime() {
            return this.expirationTime;
        }

        public boolean isExpired() {
            return this.expirationTime.isBeforeNow();
        }
    }
}

