/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.security.provider;

import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.trust.TrustEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTrustEngineRule<TokenType, RequestType extends ServletRequest>
implements SecurityPolicyRule<RequestType> {
    private static Logger log = Logger.getLogger(BaseTrustEngineRule.class);
    private TrustEngine<TokenType> trustEngine;

    public BaseTrustEngineRule(TrustEngine<TokenType> engine) {
        this.trustEngine = engine;
    }

    public TrustEngine<TokenType> getTrustEngine() {
        return this.trustEngine;
    }

    @Override
    public abstract void evaluate(RequestType var1, XMLObject var2, SecurityPolicyContext var3) throws SecurityPolicyException;

    protected abstract CriteriaSet buildCriteriaSet(String var1, RequestType var2, XMLObject var3, SecurityPolicyContext var4);

    protected boolean evaluate(TokenType token, CriteriaSet criteriaSet) throws SecurityPolicyException {
        try {
            return this.getTrustEngine().validate(token, criteriaSet);
        }
        catch (SecurityException e) {
            log.error((Object)"There was an error evaluating the request's token using the trust engine", (Throwable)e);
            return false;
        }
    }
}

