/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.security.provider;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.ServletRequestX509CredentialAdapter;
import org.opensaml.ws.security.provider.BaseTrustEngineRule;
import org.opensaml.ws.security.provider.ClientCertAuthRuleFactory;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.credential.EntityIDCriteria;
import org.opensaml.xml.security.credential.UsageCriteria;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509Util;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCertAuthRule
extends BaseTrustEngineRule<X509Credential, ServletRequest> {
    private Logger log = Logger.getLogger(ClientCertAuthRule.class);
    private ClientCertAuthRuleFactory.CertificateNameOptions certNameOptions;

    public ClientCertAuthRule(TrustEngine<X509Credential> engine, ClientCertAuthRuleFactory.CertificateNameOptions nameOptions) {
        super(engine);
        this.certNameOptions = nameOptions;
    }

    @Override
    public void evaluate(ServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
        ServletRequestX509CredentialAdapter requestCredential = null;
        try {
            requestCredential = new ServletRequestX509CredentialAdapter(request);
        }
        catch (IllegalArgumentException e) {
            this.log.info((Object)"Request did not contain a certificate, skipping client certificate authentication");
            return;
        }
        String contextIssuer = context.getIssuer();
        if (contextIssuer != null) {
            CriteriaSet criteriaSet;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting client certificate authentication using context issuer: " + contextIssuer));
            }
            if (this.evaluate(requestCredential, criteriaSet = this.buildCriteriaSet(contextIssuer, request, message, context))) {
                this.log.info((Object)("Authentication via client certificate succeeded for context issuer entity ID '" + contextIssuer + "'"));
                context.setIssuerAuthenticated(true);
            } else {
                this.log.info((Object)("Authentication via client certificate failed for context issuer entity ID '" + contextIssuer + "'"));
                context.setIssuerAuthenticated(false);
            }
            return;
        }
        String derivedIssuer = this.evaluateCertificateNameDerivedIssuers(requestCredential, request, message, context);
        if (derivedIssuer != null) {
            this.log.info((Object)("Authentication via client certificate succeeded for certificate-derived issuer entity ID '" + derivedIssuer + "'"));
            context.setIssuer(derivedIssuer);
            context.setIssuerAuthenticated(true);
            return;
        }
        derivedIssuer = this.evaluateDerivedIssuers(requestCredential, request, message, context);
        if (derivedIssuer != null) {
            this.log.info((Object)("Authentication via client certificate succeeded for derived issuer entity ID '" + derivedIssuer + "'"));
            context.setIssuer(derivedIssuer);
            context.setIssuerAuthenticated(true);
            return;
        }
    }

    @Override
    protected CriteriaSet buildCriteriaSet(String entityID, ServletRequest request, XMLObject message, SecurityPolicyContext context) {
        CriteriaSet criteriaSet = new CriteriaSet();
        if (!DatatypeHelper.isEmpty((String)entityID)) {
            criteriaSet.add((Object)new EntityIDCriteria(entityID));
        }
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        return criteriaSet;
    }

    protected String evaluateDerivedIssuers(X509Credential requestCredential, ServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
        return null;
    }

    protected String evaluateCertificateNameDerivedIssuers(X509Credential requestCredential, ServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
        String candidateIssuer = null;
        if (this.certNameOptions.evaluateSubjectDN() && (candidateIssuer = this.evaluateSubjectDN(requestCredential, request, message, context)) != null) {
            return candidateIssuer;
        }
        if (!this.certNameOptions.getSubjectAltNames().isEmpty() && (candidateIssuer = this.evaluateSubjectAltNames(requestCredential, request, message, context)) != null) {
            return candidateIssuer;
        }
        if (this.certNameOptions.evaluateSubjectCommonName() && (candidateIssuer = this.evaluateSubjectCommonName(requestCredential, request, message, context)) != null) {
            return candidateIssuer;
        }
        return null;
    }

    protected String evaluateSubjectCommonName(X509Credential requestCredential, ServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
        CriteriaSet criteriaSet;
        this.log.debug((Object)"Evaluating client cert by deriving issuer as cert CN");
        X509Certificate certificate = requestCredential.getEntityCertificate();
        String candidateIssuer = this.getCommonName(certificate);
        if (candidateIssuer != null && this.evaluate(requestCredential, criteriaSet = this.buildCriteriaSet(candidateIssuer, request, message, context))) {
            this.log.info((Object)("Authentication succeeded for issuer derived from CN'" + candidateIssuer + "'"));
            return candidateIssuer;
        }
        return null;
    }

    protected String evaluateSubjectDN(X509Credential requestCredential, ServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
        CriteriaSet criteriaSet;
        this.log.debug((Object)"Evaluating client cert by deriving issuer as cert subject DN");
        X509Certificate certificate = requestCredential.getEntityCertificate();
        String candidateIssuer = this.getSubjectName(certificate);
        if (candidateIssuer != null && this.evaluate(requestCredential, criteriaSet = this.buildCriteriaSet(candidateIssuer, request, message, context))) {
            this.log.info((Object)("Authentication succeeded for issuer derived from subject DN'" + candidateIssuer + "'"));
            return candidateIssuer;
        }
        return null;
    }

    protected String evaluateSubjectAltNames(X509Credential requestCredential, ServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
        this.log.debug((Object)"Evaluating client cert by deriving issuer from subject alt names");
        X509Certificate certificate = requestCredential.getEntityCertificate();
        for (Integer altNameType : this.certNameOptions.getSubjectAltNames()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Evaluating alt names of type: " + altNameType.toString()));
            }
            List<String> altNames = this.getAltNames(certificate, altNameType);
            for (String altName : altNames) {
                CriteriaSet criteriaSet = this.buildCriteriaSet(altName, request, message, context);
                if (!this.evaluate(requestCredential, criteriaSet)) continue;
                this.log.info((Object)("Authentication succeeded for issuer derived from subject alt name'" + altName + "'"));
                return altName;
            }
        }
        return null;
    }

    protected String getCommonName(X509Certificate cert) {
        List names = X509Util.getCommonNames((X500Principal)cert.getSubjectX500Principal());
        if (names != null && !names.isEmpty()) {
            String name = (String)names.get(0);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Extracted common name from certificate: " + name));
            }
            return name;
        }
        return null;
    }

    protected String getSubjectName(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        String name = null;
        name = !DatatypeHelper.isEmpty((String)this.certNameOptions.getX500SubjectDNFormat()) ? this.certNameOptions.getX500DNHandler().getName(cert.getSubjectX500Principal(), this.certNameOptions.getX500SubjectDNFormat()) : this.certNameOptions.getX500DNHandler().getName(cert.getSubjectX500Principal());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Extracted subject name from certificate: " + name));
        }
        return name;
    }

    protected List<String> getAltNames(X509Certificate cert, Integer altNameType) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Extracting alt names from certificate of type: " + altNameType.toString()));
        }
        Integer[] nameTypes = new Integer[]{altNameType};
        List altNames = X509Util.getAltNames((X509Certificate)cert, (Integer[])nameTypes);
        ArrayList<String> names = new ArrayList<String>();
        for (Object altNameValue : altNames) {
            if (!(altNameValue instanceof String)) {
                this.log.debug((Object)"Skipping non-String certificate alt name value");
                continue;
            }
            names.add((String)altNameValue);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Extracted alt names from certificate: " + ((Object)names).toString()));
        }
        return names;
    }
}

