/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.Validator;
import org.opensaml.xml.validation.ValidatorSuite;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLConfigurator {
    private static Logger log = Logger.getLogger(XMLConfigurator.class);
    private BasicParserPool parserPool = new BasicParserPool();
    private Schema configurationSchema;

    public XMLConfigurator() throws ConfigurationException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaSource = new StreamSource(XMLConfigurator.class.getResourceAsStream("/schema/xmltooling-config.xsd"));
        try {
            this.configurationSchema = factory.newSchema(schemaSource);
            this.parserPool.setIgnoreComments(true);
            this.parserPool.setIgnoreElementContentWhitespace(true);
            this.parserPool.setSchema(this.configurationSchema);
        }
        catch (SAXException e) {
            throw new ConfigurationException("Unable to read XMLTooling configuration schema", e);
        }
    }

    public void load(File configurationFile) throws ConfigurationException {
        if (configurationFile == null || !configurationFile.canRead()) {
            log.error((Object)("Unable to read configuration file " + configurationFile));
        }
        try {
            if (configurationFile.isDirectory()) {
                File[] configurations = configurationFile.listFiles();
                for (int i = 0; i < configurations.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Parsing configuration file " + configurations[i].getAbsolutePath()));
                    }
                    this.load(new FileInputStream(configurations[i]));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing configuration file " + configurationFile.getAbsolutePath()));
                }
                this.load(new FileInputStream(configurationFile));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void load(InputStream configurationStream) throws ConfigurationException {
        try {
            Document configuration = this.parserPool.parse(configurationStream);
            this.load(configuration);
        }
        catch (XMLParserException e) {
            log.error((Object)"Invalid configuration file", (Throwable)e);
            throw new ConfigurationException("Unable to create DocumentBuilder", e);
        }
    }

    public void load(Document configuration) throws ConfigurationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading configuration from XML Document");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n" + XMLHelper.nodeToString(configuration.getDocumentElement())));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Schema validating configuration Document");
        }
        this.validateConfiguration(configuration);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuration document validated");
        }
        this.load(configuration.getDocumentElement());
    }

    protected void load(Element configurationRoot) throws ConfigurationException {
        NodeList idAttributesNodes;
        NodeList validatorSuitesNodes;
        NodeList objectProviders = configurationRoot.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "ObjectProviders");
        if (objectProviders.getLength() > 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Preparing to load ObjectProviders");
            }
            this.initializeObjectProviders((Element)objectProviders.item(0));
            if (log.isInfoEnabled()) {
                log.info((Object)"ObjectProviders load complete");
            }
        }
        if ((validatorSuitesNodes = configurationRoot.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "ValidatorSuites")).getLength() > 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Preparing to load ValidatorSuites");
            }
            this.initializeValidatorSuites((Element)validatorSuitesNodes.item(0));
            if (log.isInfoEnabled()) {
                log.info((Object)"ValidatorSuites load complete");
            }
        }
        if ((idAttributesNodes = configurationRoot.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "IDAttributes")).getLength() > 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Preparing to load IDAttributes");
            }
            this.initializeIDAttributes((Element)idAttributesNodes.item(0));
            if (log.isInfoEnabled()) {
                log.info((Object)"IDAttributes load complete");
            }
        }
    }

    protected void initializeObjectProviders(Element objectProviders) throws ConfigurationException {
        NodeList providerList = objectProviders.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "ObjectProvider");
        for (int i = 0; i < providerList.getLength(); ++i) {
            Element objectProvider = (Element)providerList.item(i);
            Attr qNameAttrib = objectProvider.getAttributeNodeNS(null, "qualifiedName");
            QName objectProviderName = XMLHelper.getAttributeValueAsQName(qNameAttrib);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing object provider " + objectProviderName));
            }
            try {
                Element configuration = (Element)objectProvider.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "BuilderClass").item(0);
                XMLObjectBuilder builder = (XMLObjectBuilder)this.createClassInstance(configuration);
                configuration = (Element)objectProvider.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "MarshallingClass").item(0);
                Marshaller marshaller = (Marshaller)this.createClassInstance(configuration);
                configuration = (Element)objectProvider.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "UnmarshallingClass").item(0);
                Unmarshaller unmarshaller = (Unmarshaller)this.createClassInstance(configuration);
                Configuration.registerObjectProvider(objectProviderName, builder, marshaller, unmarshaller, objectProvider);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(objectProviderName + " intialized and configuration cached"));
                continue;
            }
            catch (ConfigurationException e) {
                log.fatal((Object)("Error initializing object provier " + objectProvider), (Throwable)e);
                Configuration.deregisterObjectProvider(objectProviderName);
                throw e;
            }
        }
    }

    protected void initializeValidatorSuites(Element validatorSuitesElement) throws ConfigurationException {
        NodeList validatorSuiteList = validatorSuitesElement.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "ValidatorSuite");
        for (int i = 0; i < validatorSuiteList.getLength(); ++i) {
            Element validatorSuiteElement = (Element)validatorSuiteList.item(i);
            String validatorSuiteId = validatorSuiteElement.getAttributeNS(null, "id");
            ValidatorSuite validatorSuite = new ValidatorSuite(validatorSuiteId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing ValidatorSuite " + validatorSuiteId));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)XMLHelper.nodeToString(validatorSuiteElement));
            }
            NodeList validatorList = validatorSuiteElement.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "Validator");
            for (int j = 0; j < validatorList.getLength(); ++j) {
                Element validatorElement = (Element)validatorList.item(j);
                QName validatorQName = XMLHelper.getAttributeValueAsQName(validatorElement.getAttributeNodeNS(null, "qualifiedName"));
                Validator validator = (Validator)this.createClassInstance(validatorElement);
                validatorSuite.registerValidator(validatorQName, validator);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ValidtorSuite " + validatorSuiteId + " has been initialized"));
            }
            Configuration.registerValidatorSuite(validatorSuiteId, validatorSuite, validatorSuiteElement);
        }
    }

    protected void initializeIDAttributes(Element idAttributesElement) throws ConfigurationException {
        NodeList idAttributeList = idAttributesElement.getElementsByTagNameNS("http://www.opensaml.org/xmltooling-config", "IDAttribute");
        for (int i = 0; i < idAttributeList.getLength(); ++i) {
            Element idAttributeElement = (Element)idAttributeList.item(i);
            QName attributeQName = XMLHelper.getElementContentAsQName(idAttributeElement);
            if (attributeQName == null) {
                log.info((Object)"IDAttribute element was empty, no registration performed");
                continue;
            }
            Configuration.registerIDAttribute(attributeQName);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("IDAttribute " + attributeQName + " has been registered"));
        }
    }

    protected Object createClassInstance(Element configuration) throws ConfigurationException {
        String className = configuration.getAttributeNS(null, "className");
        if ((className = DatatypeHelper.safeTrimOrNullString(className)) == null) {
            return null;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating instance of " + className));
            }
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error((Object)("Can not create instance of " + className), (Throwable)e);
            throw new ConfigurationException("Can not create instance of " + className, e);
        }
    }

    protected void validateConfiguration(Document configuration) throws ConfigurationException {
        try {
            javax.xml.validation.Validator schemaValidator = this.configurationSchema.newValidator();
            schemaValidator.validate(new DOMSource(configuration));
        }
        catch (IOException e) {
            String errorMsg = "Unable to read configuration file DOM";
            log.error((Object)errorMsg, (Throwable)e);
            throw new ConfigurationException(errorMsg, e);
        }
        catch (SAXException e) {
            String errorMsg = "Configuration file does not validate against schema";
            log.error((Object)errorMsg, (Throwable)e);
            throw new ConfigurationException(errorMsg, e);
        }
    }
}

