/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLObjectBuilderFactory {
    private static Logger log = Logger.getLogger(XMLObjectBuilderFactory.class);
    private Map<QName, XMLObjectBuilder> builders = new ConcurrentHashMap<QName, XMLObjectBuilder>();

    public XMLObjectBuilder getBuilder(QName key) {
        if (key == null) {
            return null;
        }
        return this.builders.get(key);
    }

    public XMLObjectBuilder getBuilder(Element domElement) {
        XMLObjectBuilder builder = this.getBuilder(XMLHelper.getXSIType(domElement));
        if (builder == null) {
            builder = this.getBuilder(XMLHelper.getNodeQName(domElement));
        }
        return builder;
    }

    public Map<QName, XMLObjectBuilder> getBuilders() {
        return Collections.unmodifiableMap(this.builders);
    }

    public void registerBuilder(QName builderKey, XMLObjectBuilder builder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering builder, " + builder.getClass().getName() + " under key " + builderKey));
        }
        this.builders.put(builderKey, builder);
    }

    public XMLObjectBuilder deregisterBuilder(QName builderKey) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deregistering builder for object type " + builderKey));
        }
        return this.builders.remove(this.builders.get(builderKey));
    }
}

