/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.encryption;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.opensaml.xml.encryption.AbstractEncryptedKeyResolver;
import org.opensaml.xml.encryption.EncryptedData;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.encryption.EncryptedKeyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingEncryptedKeyResolver
extends AbstractEncryptedKeyResolver {
    private final List<EncryptedKeyResolver> resolvers;
    private Logger log = Logger.getLogger(ChainingEncryptedKeyResolver.class);

    public ChainingEncryptedKeyResolver() {
        this.resolvers = new ArrayList<EncryptedKeyResolver>();
    }

    public List<EncryptedKeyResolver> getResolverChain() {
        return this.resolvers;
    }

    @Override
    public Iterable<EncryptedKey> resolve(EncryptedData encryptedData) {
        if (this.resolvers.isEmpty()) {
            this.log.warn((Object)"Chaining encrypted key resolver resolution was attempted with an empty resolver chain");
            throw new IllegalStateException("The resolver chain is empty");
        }
        return new ChainingIterable(this, encryptedData);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChainingIterator
    implements Iterator<EncryptedKey> {
        private Logger log = Logger.getLogger(ChainingIterator.class);
        private ChainingEncryptedKeyResolver parent;
        private EncryptedData encryptedData;
        private Iterator<EncryptedKeyResolver> resolverIterator;
        private Iterator<EncryptedKey> keyIterator;
        private EncryptedKeyResolver currentResolver;
        private EncryptedKey nextKey;

        public ChainingIterator(ChainingEncryptedKeyResolver resolver, EncryptedData encData) {
            this.parent = resolver;
            this.encryptedData = encData;
            this.resolverIterator = this.parent.getResolverChain().iterator();
            this.keyIterator = this.getNextKeyIterator();
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextKey != null) {
                return true;
            }
            this.nextKey = this.getNextKey();
            return this.nextKey != null;
        }

        @Override
        public EncryptedKey next() {
            if (this.nextKey != null) {
                EncryptedKey tempKey = this.nextKey;
                this.nextKey = null;
                return tempKey;
            }
            EncryptedKey tempKey = this.getNextKey();
            if (tempKey != null) {
                return tempKey;
            }
            throw new NoSuchElementException("No more EncryptedKey elements are available");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported by this iterator");
        }

        private Iterator<EncryptedKey> getNextKeyIterator() {
            if (this.resolverIterator.hasNext()) {
                this.currentResolver = this.resolverIterator.next();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Getting key iterator from next resolver: " + this.currentResolver.getClass().toString()));
                }
                return this.currentResolver.resolve(this.encryptedData).iterator();
            }
            this.log.debug((Object)"No more resolvers available in the resolver chain");
            this.currentResolver = null;
            return null;
        }

        private EncryptedKey getNextKey() {
            EncryptedKey tempKey;
            if (this.keyIterator != null) {
                while (this.keyIterator.hasNext()) {
                    tempKey = this.keyIterator.next();
                    if (!this.parent.matchRecipient(tempKey.getRecipient())) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Found matching encrypted key: " + tempKey.toString()));
                    }
                    return tempKey;
                }
            }
            this.keyIterator = this.getNextKeyIterator();
            while (this.keyIterator != null) {
                while (this.keyIterator.hasNext()) {
                    tempKey = this.keyIterator.next();
                    if (!this.parent.matchRecipient(tempKey.getRecipient())) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Found matching encrypted key: " + tempKey.toString()));
                    }
                    return tempKey;
                }
                this.keyIterator = this.getNextKeyIterator();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChainingIterable
    implements Iterable<EncryptedKey> {
        private ChainingEncryptedKeyResolver parent;
        private EncryptedData encryptedData;

        public ChainingIterable(ChainingEncryptedKeyResolver resolver, EncryptedData encData) {
            this.parent = resolver;
            this.encryptedData = encData;
        }

        @Override
        public Iterator<EncryptedKey> iterator() {
            return new ChainingIterator(this.parent, this.encryptedData);
        }
    }
}

