/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.encryption;

import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.encryption.EncryptedData;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.encryption.EncryptionException;
import org.opensaml.xml.encryption.EncryptionParameters;
import org.opensaml.xml.encryption.KeyEncryptionParameters;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.impl.KeyInfoBuilder;
import org.opensaml.xml.util.DatatypeHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encrypter {
    private Logger log = Logger.getLogger(Encrypter.class);
    private Unmarshaller encryptedDataUnmarshaller;
    private Unmarshaller encryptedKeyUnmarshaller;
    private KeyInfoBuilder keyInfoBuilder;

    public Encrypter() {
        UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
        this.encryptedDataUnmarshaller = unmarshallerFactory.getUnmarshaller(EncryptedData.DEFAULT_ELEMENT_NAME);
        this.encryptedKeyUnmarshaller = unmarshallerFactory.getUnmarshaller(EncryptedKey.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        this.keyInfoBuilder = (KeyInfoBuilder)builderFactory.getBuilder(KeyInfo.DEFAULT_ELEMENT_NAME);
    }

    public EncryptedData encryptElement(XMLObject xmlObject, EncryptionParameters encParams) throws EncryptionException {
        ArrayList<KeyEncryptionParameters> emptyKEKParamsList = new ArrayList<KeyEncryptionParameters>();
        return this.encryptElement(xmlObject, encParams, emptyKEKParamsList, false);
    }

    public EncryptedData encryptElement(XMLObject xmlObject, EncryptionParameters encParams, KeyEncryptionParameters kekParams) throws EncryptionException {
        ArrayList<KeyEncryptionParameters> kekParamsList = new ArrayList<KeyEncryptionParameters>();
        kekParamsList.add(kekParams);
        return this.encryptElement(xmlObject, encParams, kekParamsList, false);
    }

    public EncryptedData encryptElement(XMLObject xmlObject, EncryptionParameters encParams, List<KeyEncryptionParameters> kekParamsList) throws EncryptionException {
        return this.encryptElement(xmlObject, encParams, kekParamsList, false);
    }

    public EncryptedData encryptElementContent(XMLObject xmlObject, EncryptionParameters encParams) throws EncryptionException {
        ArrayList<KeyEncryptionParameters> emptyKEKParamsList = new ArrayList<KeyEncryptionParameters>();
        return this.encryptElement(xmlObject, encParams, emptyKEKParamsList, true);
    }

    public EncryptedData encryptElementContent(XMLObject xmlObject, EncryptionParameters encParams, KeyEncryptionParameters kekParams) throws EncryptionException {
        ArrayList<KeyEncryptionParameters> kekParamsList = new ArrayList<KeyEncryptionParameters>();
        kekParamsList.add(kekParams);
        return this.encryptElement(xmlObject, encParams, kekParamsList, true);
    }

    public EncryptedData encryptElementContent(XMLObject xmlObject, EncryptionParameters encParams, List<KeyEncryptionParameters> kekParamsList) throws EncryptionException {
        return this.encryptElement(xmlObject, encParams, kekParamsList, true);
    }

    public List<EncryptedKey> encryptKey(Key key, List<KeyEncryptionParameters> kekParamsList, Document containingDocument) throws EncryptionException {
        this.checkParams(kekParamsList, false);
        ArrayList<EncryptedKey> encKeys = new ArrayList<EncryptedKey>();
        for (KeyEncryptionParameters kekParam : kekParamsList) {
            encKeys.add(this.encryptKey(key, kekParam, containingDocument));
        }
        return encKeys;
    }

    public EncryptedKey encryptKey(Key key, KeyEncryptionParameters kekParams, Document containingDocument) throws EncryptionException {
        this.checkParams(kekParams, false);
        Key encryptionKey = SecurityHelper.extractEncryptionKey(kekParams.getEncryptionCredential());
        String encryptionAlgorithmURI = kekParams.getAlgorithm();
        EncryptedKey encryptedKey = this.encryptKey(key, encryptionKey, encryptionAlgorithmURI, containingDocument);
        if (kekParams.getKeyInfoGenerator() != null) {
            KeyInfoGenerator generator = kekParams.getKeyInfoGenerator();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Dynamically generating KeyInfo from Credential for EncryptedKey using generator: " + generator.getClass().getName()));
            }
            try {
                encryptedKey.setKeyInfo(generator.generate(kekParams.getEncryptionCredential()));
            }
            catch (SecurityException e) {
                this.log.error((Object)"Error during EncryptedKey KeyInfo generation", (Throwable)e);
                throw new EncryptionException("Error during EncryptedKey KeyInfo generation", e);
            }
        }
        if (kekParams.getRecipient() != null) {
            encryptedKey.setRecipient(kekParams.getRecipient());
        }
        return encryptedKey;
    }

    protected EncryptedKey encryptKey(Key targetKey, Key encryptionKey, String encryptionAlgorithmURI, Document containingDocument) throws EncryptionException {
        EncryptedKey encryptedKey;
        org.apache.xml.security.encryption.EncryptedKey apacheEncryptedKey;
        XMLCipher xmlCipher;
        if (targetKey == null) {
            this.log.error((Object)"Target key for key encryption was null");
            throw new EncryptionException("Target key was null");
        }
        if (encryptionKey == null) {
            this.log.error((Object)"Encryption key for key encryption was null");
            throw new EncryptionException("Encryption key was null");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Encrypting key '" + targetKey.getAlgorithm() + "' with key '" + encryptionKey.getAlgorithm() + "' with algorithm URI '" + encryptionAlgorithmURI + "'"));
        }
        try {
            xmlCipher = XMLCipher.getInstance((String)encryptionAlgorithmURI);
            xmlCipher.init(3, encryptionKey);
        }
        catch (XMLEncryptionException e) {
            this.log.error((Object)"Error initializing cipher instance on key encryption", (Throwable)e);
            throw new EncryptionException("Error initializing cipher instance on key encryption", (Exception)((Object)e));
        }
        try {
            apacheEncryptedKey = xmlCipher.encryptKey(containingDocument, targetKey);
        }
        catch (XMLEncryptionException e) {
            this.log.error((Object)"Error encrypting element on key encryption", (Throwable)e);
            throw new EncryptionException("Error encrypting element on key encryption", (Exception)((Object)e));
        }
        try {
            Element encKeyElement = xmlCipher.martial(containingDocument, apacheEncryptedKey);
            encryptedKey = (EncryptedKey)this.encryptedKeyUnmarshaller.unmarshall(encKeyElement);
        }
        catch (UnmarshallingException e) {
            this.log.error((Object)"Error unmarshalling EncryptedKey element", (Throwable)e);
            throw new EncryptionException("Error unmarshalling EncryptedKey element");
        }
        return encryptedKey;
    }

    protected EncryptedData encryptElement(XMLObject xmlObject, Key encryptionKey, String encryptionAlgorithmURI, boolean encryptContentMode) throws EncryptionException {
        EncryptedData encryptedData;
        org.apache.xml.security.encryption.EncryptedData apacheEncryptedData;
        XMLCipher xmlCipher;
        if (xmlObject == null) {
            this.log.error((Object)"XMLObject for encryption was null");
            throw new EncryptionException("XMLObject was null");
        }
        if (encryptionKey == null) {
            this.log.error((Object)"Encryption key for key encryption was null");
            throw new EncryptionException("Encryption key was null");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Encrypting XMLObject '" + xmlObject.getElementQName() + " with key '" + encryptionKey.getAlgorithm() + "' using algorithm URI '" + encryptionAlgorithmURI + "' with content mode '" + encryptContentMode + "'"));
        }
        this.checkAndMarshall(xmlObject);
        Element targetElement = xmlObject.getDOM();
        Document ownerDocument = targetElement.getOwnerDocument();
        try {
            xmlCipher = XMLCipher.getInstance((String)encryptionAlgorithmURI);
            xmlCipher.init(1, encryptionKey);
        }
        catch (XMLEncryptionException e) {
            this.log.error((Object)"Error initializing cipher instance on XMLObject encryption", (Throwable)e);
            throw new EncryptionException("Error initializing cipher instance", (Exception)((Object)e));
        }
        try {
            apacheEncryptedData = xmlCipher.encryptData(ownerDocument, targetElement, encryptContentMode);
        }
        catch (Exception e) {
            this.log.error((Object)"Error encrypting XMLObject", (Throwable)e);
            throw new EncryptionException("Error encrypting XMLObject", e);
        }
        try {
            Element encDataElement = xmlCipher.martial(ownerDocument, apacheEncryptedData);
            encryptedData = (EncryptedData)this.encryptedDataUnmarshaller.unmarshall(encDataElement);
        }
        catch (UnmarshallingException e) {
            this.log.error((Object)"Error unmarshalling EncryptedData element", (Throwable)e);
            throw new EncryptionException("Error unmarshalling EncryptedData element", e);
        }
        return encryptedData;
    }

    private EncryptedData encryptElement(XMLObject xmlObject, EncryptionParameters encParams, List<KeyEncryptionParameters> kekParamsList, boolean encryptContentMode) throws EncryptionException {
        this.checkParams(encParams, kekParamsList);
        String encryptionAlgorithmURI = encParams.getAlgorithm();
        Key encryptionKey = SecurityHelper.extractEncryptionKey(encParams.getEncryptionCredential());
        if (encryptionKey == null) {
            encryptionKey = this.generateEncryptionKey(encryptionAlgorithmURI);
        }
        EncryptedData encryptedData = this.encryptElement(xmlObject, encryptionKey, encryptionAlgorithmURI, encryptContentMode);
        Document ownerDocument = encryptedData.getDOM().getOwnerDocument();
        if (encParams.getKeyInfoGenerator() != null) {
            KeyInfoGenerator generator = encParams.getKeyInfoGenerator();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Dynamically generating KeyInfo from Credential for EncryptedData using generator: " + generator.getClass().getName()));
            }
            try {
                encryptedData.setKeyInfo(generator.generate(encParams.getEncryptionCredential()));
            }
            catch (SecurityException e) {
                this.log.error((Object)"Error during EncryptedData KeyInfo generation", (Throwable)e);
                throw new EncryptionException("Error during EncryptedData KeyInfo generation", e);
            }
        }
        for (KeyEncryptionParameters kekParams : kekParamsList) {
            EncryptedKey encryptedKey = this.encryptKey(encryptionKey, kekParams, ownerDocument);
            if (encryptedData.getKeyInfo() == null) {
                KeyInfo keyInfo = this.keyInfoBuilder.buildObject();
                encryptedData.setKeyInfo(keyInfo);
            }
            encryptedData.getKeyInfo().getEncryptedKeys().add(encryptedKey);
        }
        return encryptedData;
    }

    protected void checkAndMarshall(XMLObject xmlObject) throws EncryptionException {
        Element targetElement = xmlObject.getDOM();
        if (targetElement == null) {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(xmlObject);
            try {
                targetElement = marshaller.marshall(xmlObject);
            }
            catch (MarshallingException e) {
                this.log.error((Object)"Error marshalling target XMLObject", (Throwable)e);
                throw new EncryptionException("Error marshalling target XMLObject", e);
            }
        }
    }

    protected void checkParams(EncryptionParameters encParams) throws EncryptionException {
        if (encParams == null) {
            this.log.error((Object)"Data encryption parameters are required");
            throw new EncryptionException("Data encryption parameters are required");
        }
        if (DatatypeHelper.isEmpty(encParams.getAlgorithm())) {
            this.log.error((Object)"Data encryption algorithm URI is required");
            throw new EncryptionException("Data encryption algorithm URI is required");
        }
    }

    protected void checkParams(KeyEncryptionParameters kekParams, boolean allowEmpty) throws EncryptionException {
        if (kekParams == null) {
            if (allowEmpty) {
                return;
            }
            this.log.error((Object)"Key encryption parameters are required");
            throw new EncryptionException("Key encryption parameters are required");
        }
        if (DatatypeHelper.isEmpty(kekParams.getAlgorithm())) {
            this.log.error((Object)"Key encryption algorithm URI is required");
            throw new EncryptionException("Key encryption algorithm URI is required");
        }
        if (SecurityHelper.extractEncryptionKey(kekParams.getEncryptionCredential()) == null) {
            this.log.error((Object)"Key encryption credential and contained key are required");
            throw new EncryptionException("Key encryption credential and contained key are required");
        }
    }

    protected void checkParams(List<KeyEncryptionParameters> kekParamsList, boolean allowEmpty) throws EncryptionException {
        if (kekParamsList == null || kekParamsList.isEmpty()) {
            if (allowEmpty) {
                return;
            }
            this.log.error((Object)"Key encryption parameters list may not be empty");
            throw new EncryptionException("Key encryption parameters list may not be empty");
        }
        for (KeyEncryptionParameters kekParams : kekParamsList) {
            this.checkParams(kekParams, false);
        }
    }

    protected void checkParams(EncryptionParameters encParams, List<KeyEncryptionParameters> kekParamsList) throws EncryptionException {
        this.checkParams(encParams);
        this.checkParams(kekParamsList, true);
        if (SecurityHelper.extractEncryptionKey(encParams.getEncryptionCredential()) == null && (kekParamsList == null || kekParamsList.isEmpty())) {
            this.log.error((Object)"Using a generated encryption key requires a KeyEncryptionParameters object and key encryption key");
            throw new EncryptionException("Using a generated encryption key requires a KeyEncryptionParameters object and key encryption key");
        }
    }

    protected SecretKey generateEncryptionKey(String encryptionAlgorithmURI) throws EncryptionException {
        try {
            return SecurityHelper.generateSymmetricKey(encryptionAlgorithmURI);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)("Could not generate encryption key, algorithm URI was invalid: " + encryptionAlgorithmURI));
            throw new EncryptionException("Could not generate encryption key, algorithm URI was invalid: " + encryptionAlgorithmURI);
        }
        catch (KeyException e) {
            this.log.error((Object)("Could not generate encryption key from algorithm URI: " + encryptionAlgorithmURI));
            throw new EncryptionException("Could not generate encryption key from algorithm URI: " + encryptionAlgorithmURI);
        }
    }

    static {
        if (!Init.isInitialized()) {
            Init.init();
        }
    }
}

