/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.io;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractXMLObjectMarshaller
implements Marshaller {
    private static Logger log = Logger.getLogger(AbstractXMLObjectMarshaller.class);
    private QName targetQName;
    private MarshallerFactory marshallerFactory;

    protected AbstractXMLObjectMarshaller() {
        this.marshallerFactory = Configuration.getMarshallerFactory();
    }

    protected AbstractXMLObjectMarshaller(String targetNamespaceURI, String targetLocalName) {
        this.targetQName = XMLHelper.constructQName(targetNamespaceURI, targetLocalName, null);
        this.marshallerFactory = Configuration.getMarshallerFactory();
    }

    public Element marshall(XMLObject xmlObject) throws MarshallingException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            return this.marshall(xmlObject, document);
        }
        catch (ParserConfigurationException e) {
            throw new MarshallingException("Unable to create Document to place marshalled elements in", e);
        }
    }

    public Element marshall(XMLObject xmlObject, Document document) throws MarshallingException {
        Element domElement;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting to marshall " + xmlObject.getElementQName()));
        }
        if (document == null) {
            throw new MarshallingException("Given document may not be null");
        }
        this.checkXMLObjectIsTarget(xmlObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking if " + xmlObject.getElementQName() + " contains a cached DOM representation"));
        }
        if ((domElement = xmlObject.getDOM()) != null) {
            this.prepareForAdoption(xmlObject);
            if (domElement.getOwnerDocument() != document) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Adopting DOM of XMLObject into given Document");
                }
                XMLHelper.adoptElement(domElement, document);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting DOM of XMLObject as document element of given Document");
            }
            this.setDocumentElement(document, domElement);
            return domElement;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(xmlObject.getElementQName() + " does not contain a cached DOM representation"));
            log.debug((Object)("Creating Element to marshall " + xmlObject.getElementQName() + " into"));
        }
        domElement = XMLHelper.constructElement(document, xmlObject.getElementQName());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting created element as document root");
        }
        this.setDocumentElement(document, domElement);
        domElement = this.marshallInto(xmlObject, domElement);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting created element to DOM cache for XMLObject " + xmlObject.getElementQName()));
        }
        xmlObject.setDOM(domElement);
        xmlObject.releaseParentDOM(true);
        return domElement;
    }

    public Element marshall(XMLObject xmlObject, Element parentElement) throws MarshallingException {
        Element domElement;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting to marshall " + xmlObject.getElementQName() + " as child of " + XMLHelper.getNodeQName(parentElement)));
        }
        if (parentElement == null) {
            throw new MarshallingException("Given parent element is null");
        }
        this.checkXMLObjectIsTarget(xmlObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking if " + xmlObject.getElementQName() + " contains a cached DOM representation"));
        }
        if ((domElement = xmlObject.getDOM()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(xmlObject.getElementQName() + " contains a cached DOM representation"));
            }
            this.prepareForAdoption(xmlObject);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Appending DOM of XMLObject " + xmlObject.getElementQName() + " as child of parent element " + XMLHelper.getNodeQName(parentElement)));
            }
            XMLHelper.appendChildElement(parentElement, domElement);
            return domElement;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(xmlObject.getElementQName() + " does not contain a cached DOM representation"));
            log.debug((Object)("Creating Element to marshall " + xmlObject.getElementQName() + " into"));
        }
        Document owningDocument = parentElement.getOwnerDocument();
        domElement = XMLHelper.constructElement(owningDocument, xmlObject.getElementQName());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Appending newly created element to given parent element");
        }
        XMLHelper.appendChildElement(parentElement, domElement);
        domElement = this.marshallInto(xmlObject, domElement);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting created element to DOM cache for XMLObject " + xmlObject.getElementQName()));
        }
        xmlObject.setDOM(domElement);
        xmlObject.releaseParentDOM(true);
        return domElement;
    }

    protected void setDocumentElement(Document document, Element element) {
        Element documentRoot = document.getDocumentElement();
        if (documentRoot != null) {
            document.replaceChild(element, documentRoot);
        } else {
            document.appendChild(element);
        }
    }

    protected Element marshallInto(XMLObject xmlObject, Element targetElement) throws MarshallingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting namespace prefix for " + xmlObject.getElementQName().getPrefix() + " for XMLObject " + xmlObject.getElementQName()));
        }
        this.marshallNamespacePrefix(xmlObject, targetElement);
        this.marshallSchemaInstanceAttributes(xmlObject, targetElement);
        this.marshallNamespaces(xmlObject, targetElement);
        this.marshallAttributes(xmlObject, targetElement);
        this.marshallChildElements(xmlObject, targetElement);
        this.marshallElementContent(xmlObject, targetElement);
        return targetElement;
    }

    protected void checkXMLObjectIsTarget(XMLObject xmlObject) throws MarshallingException {
        QName type;
        if (this.targetQName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Targeted QName checking is not available for this marshaller, XMLObject " + xmlObject.getElementQName() + " was not verified"));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking that " + xmlObject.getElementQName() + " meets target criteria"));
        }
        if ((type = xmlObject.getSchemaType()) != null && type.equals(this.targetQName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(xmlObject.getElementQName() + " schema type matches target"));
            }
            return;
        }
        QName elementQName = xmlObject.getElementQName();
        if (elementQName.equals(this.targetQName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(xmlObject.getElementQName() + " element QName matches target"));
            }
            return;
        }
        String errorMsg = "This marshaller only operations on " + this.targetQName + " elements not " + xmlObject.getElementQName();
        log.error((Object)errorMsg);
        throw new MarshallingException(errorMsg);
    }

    protected void marshallNamespacePrefix(XMLObject xmlObject, Element domElement) {
        String prefix = xmlObject.getElementQName().getPrefix();
        if ((prefix = DatatypeHelper.safeTrimOrNullString(prefix)) != null) {
            domElement.setPrefix(prefix);
        }
    }

    protected void marshallChildElements(XMLObject xmlObject, Element domElement) throws MarshallingException {
        List<XMLObject> childXMLObjects;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Marshalling child elements for XMLObject " + xmlObject.getElementQName()));
        }
        if ((childXMLObjects = xmlObject.getOrderedChildren()) != null && childXMLObjects.size() > 0) {
            for (XMLObject childXMLObject : childXMLObjects) {
                Marshaller marshaller;
                if (childXMLObject == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Getting marshaller for child XMLObject " + childXMLObject.getElementQName()));
                }
                if ((marshaller = this.marshallerFactory.getMarshaller(childXMLObject)) == null) {
                    marshaller = this.marshallerFactory.getMarshaller(Configuration.getDefaultProviderQName());
                    if (marshaller == null) {
                        String errorMsg = "No marshaller available for " + childXMLObject.getElementQName() + ", child of " + xmlObject.getElementQName();
                        log.error((Object)errorMsg);
                        throw new MarshallingException(errorMsg);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No marshaller was registered for " + childXMLObject.getElementQName() + ", child of " + xmlObject.getElementQName() + " but the default marshaller " + marshaller.getClass().getName() + " was available, using it."));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Marshalling " + childXMLObject.getElementQName() + " and adding it to DOM"));
                }
                marshaller.marshall(childXMLObject, domElement);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No child elements to marshall for XMLObject " + xmlObject.getElementQName()));
        }
    }

    protected void marshallNamespaces(XMLObject xmlObject, Element domElement) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Marshalling namespace attributes for XMLObject " + xmlObject.getElementQName()));
        }
        Set<Namespace> namespaces = xmlObject.getNamespaces();
        for (Namespace namespace : namespaces) {
            if (!namespace.alwaysDeclare() && XMLHelper.lookupNamespaceURI(domElement, namespace.getNamespacePrefix()) != null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Namespace " + namespace + " has already been declared on an ancestor of " + xmlObject.getElementQName() + " no need to add it here"));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding namespace decleration " + namespace + " to " + xmlObject.getElementQName()));
            }
            String nsURI = DatatypeHelper.safeTrimOrNullString(namespace.getNamespaceURI());
            String nsPrefix = DatatypeHelper.safeTrimOrNullString(namespace.getNamespacePrefix());
            XMLHelper.appendNamespaceDecleration(domElement, nsURI, nsPrefix);
        }
    }

    protected void marshallSchemaInstanceAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
        QName type;
        if (!DatatypeHelper.isEmpty(xmlObject.getSchemaLocation())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting xsi:schemaLocation for XMLObject " + xmlObject.getElementQName() + " to " + xmlObject.getSchemaLocation()));
            }
            domElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", xmlObject.getSchemaLocation());
        }
        if (!DatatypeHelper.isEmpty(xmlObject.getNoNamespaceSchemaLocation())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting xsi:noNamespaceSchemaLocation for XMLObject " + xmlObject.getElementQName() + " to " + xmlObject.getNoNamespaceSchemaLocation()));
            }
            domElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", xmlObject.getNoNamespaceSchemaLocation());
        }
        if ((type = xmlObject.getSchemaType()) == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting xsi:type attribute with for XMLObject " + xmlObject.getElementQName()));
        }
        String typeLocalName = DatatypeHelper.safeTrimOrNullString(type.getLocalPart());
        String typePrefix = DatatypeHelper.safeTrimOrNullString(type.getPrefix());
        if (typeLocalName == null) {
            throw new MarshallingException("The type QName on XMLObject " + xmlObject.getElementQName() + " may not have a null local name");
        }
        if (type.getNamespaceURI() == null) {
            throw new MarshallingException("The type URI QName on XMLObject " + xmlObject.getElementQName() + " may not have a null namespace URI");
        }
        String attributeValue = typePrefix == null ? typeLocalName : typePrefix + ":" + typeLocalName;
        domElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", attributeValue);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding XSI namespace to list of namespaces used by XMLObject " + xmlObject.getElementQName()));
        }
        xmlObject.addNamespace(new Namespace("http://www.w3.org/2001/XMLSchema-instance", "xsi"));
    }

    protected abstract void marshallAttributes(XMLObject var1, Element var2) throws MarshallingException;

    protected abstract void marshallElementContent(XMLObject var1, Element var2) throws MarshallingException;

    private void prepareForAdoption(XMLObject domCachingObject) throws MarshallingException {
        if (domCachingObject.getParent() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rooting all visible namespaces of XMLObject " + domCachingObject.getElementQName() + " before adding it to new parent Element"));
            }
            try {
                XMLHelper.rootNamespaces(domCachingObject.getDOM());
            }
            catch (XMLParserException e) {
                String errorMsg = "Unable to root namespaces of cached DOM element, " + domCachingObject.getElementQName();
                log.error((Object)errorMsg, (Throwable)e);
                throw new MarshallingException(errorMsg, e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Release DOM of XMLObject parent");
            }
            domCachingObject.releaseParentDOM(true);
        }
    }
}

