/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.io;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallerFactory {
    private static Logger log = Logger.getLogger(MarshallerFactory.class);
    private Map<QName, Marshaller> marshallers = new ConcurrentHashMap<QName, Marshaller>();

    public Marshaller getMarshaller(QName key) {
        if (key == null) {
            return null;
        }
        return this.marshallers.get(key);
    }

    public Marshaller getMarshaller(XMLObject xmlObject) {
        Marshaller marshaller = this.getMarshaller(xmlObject.getSchemaType());
        if (marshaller == null) {
            marshaller = this.getMarshaller(xmlObject.getElementQName());
        }
        return marshaller;
    }

    public Map<QName, Marshaller> getMarshallers() {
        return Collections.unmodifiableMap(this.marshallers);
    }

    public void registerMarshaller(QName key, Marshaller marshaller) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering marshaller, " + marshaller.getClass().getName() + ", for object type " + key));
        }
        this.marshallers.put(key, marshaller);
    }

    public Marshaller deregisterMarshaller(QName key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deregistering marshaller for object type " + key));
        }
        return this.marshallers.remove(key);
    }
}

