/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.io;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmarshallerFactory {
    private static Logger log = Logger.getLogger(UnmarshallerFactory.class);
    private Map<QName, Unmarshaller> unmarshallers = new ConcurrentHashMap<QName, Unmarshaller>();

    public Unmarshaller getUnmarshaller(QName key) {
        if (key == null) {
            return null;
        }
        return this.unmarshallers.get(key);
    }

    public Unmarshaller getUnmarshaller(Element domElement) {
        Unmarshaller unmarshaller = this.getUnmarshaller(XMLHelper.getXSIType(domElement));
        if (unmarshaller == null) {
            unmarshaller = this.getUnmarshaller(XMLHelper.getNodeQName(domElement));
        }
        return unmarshaller;
    }

    public Map<QName, Unmarshaller> getUnmarshallers() {
        return Collections.unmodifiableMap(this.unmarshallers);
    }

    public void registerUnmarshaller(QName key, Unmarshaller unmarshaller) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering unmarshaller, " + unmarshaller.getClass().getName() + ", for object type " + key));
        }
        this.unmarshallers.put(key, unmarshaller);
    }

    public Unmarshaller deregisterUnmarshaller(QName key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deregistering marshaller for object type " + key));
        }
        return this.unmarshallers.remove(key);
    }
}

